local assets=
{
    Asset("ANIM", "anim/fa_walkingshoes.zip"),
    
    Asset("ATLAS", "images/inventoryimages/fa_walkingshoes.xml"),
    Asset("IMAGE", "images/inventoryimages/fa_walkingshoes.tex"),
}

local function fn(Sim)
		local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		MakeInventoryPhysics(inst)
		
		inst.AnimState:SetBank("fa_walkingshoes")
		inst.AnimState:SetBuild("fa_walkingshoes")
		inst.AnimState:PlayAnimation("idle")
	    
	    local minimap = inst.entity:AddMiniMapEntity()
    	minimap:SetIcon( "fa_walkingshoes.tex" )

		inst:AddComponent("inspectable")
	    inst:AddComponent("inventoryitem")
    	inst.components.inventoryitem.imagename="fa_walkingshoes"
    	inst.components.inventoryitem.atlasname="images/inventoryimages/fa_walkingshoes.xml"
	    
		inst:AddComponent("tradable")
	    
		return inst
	end

return Prefab( "common/inventory/fa_walkingshoes", fn, assets)