PrefabFiles = {
	"wond",
    "specialfoods",
    "cookbook",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/wond.tex" ),
    Asset( "IMAGE", "images/selectscreen_portraits/wond.tex" ),
    Asset( "IMAGE", "images/selectscreen_portraits/wond_silho.tex" ),
    Asset( "IMAGE", "bigportraits/wond.tex" ),

	Asset( "ATLAS", "images/saveslot_portraits/wond.xml" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wond.xml" ),
    Asset( "ATLAS", "images/selectscreen_portraits/wond_silho.xml" ),
    Asset( "ATLAS", "bigportraits/wond.xml" ),

	Asset( "IMAGE", "images/wond.tex" ),
	Asset( "ATLAS", "images/wond.xml" ),

}
table.insert(GLOBAL.CHARACTER_GENDERS.FEMALE, "wond")

AddMinimapAtlas("images/wond.xml")
AddModCharacter("wond")

local require = GLOBAL.require
local GetPlayer = GLOBAL.GetPlayer
local STRINGS = GLOBAL.STRINGS

if GLOBAL.LanguageTranslator.defaultlang == "chs" then 
    require "strings_wond_chs"
    STRINGS.CHARACTERS.WOND = require "speech_wond_chs"
else
    require "strings_wond"
    STRINGS.CHARACTERS.WOND = require "speech_wond"
end

TUNING.WOND_BASE_HEALTH = 100
TUNING.WOND_BASE_HUNGER = 150
TUNING.WOND_BASE_SANITY = 125
TUNING.WOND_BASE_DAMAGE_MULT = 0.75

TUNING.SPECFOOD_CHANCE_DROP = 0.85


-- Wonda's Cookpot

-- pathcing Highlight for correct additional colour
local Highlight = require("components/highlight")
local oldhighlight = Highlight.Highlight
function Highlight:Highlight(r, g, b)
    if self.inst.useraddcolour then
        self.base_add_colour_red = self.inst.useraddcolour.x
        self.base_add_colour_green = self.inst.useraddcolour.y
        self.base_add_colour_blue = self.inst.useraddcolour.z
    end
    oldhighlight(self, r, g, b)
end

AddPrefabPostInit("cookpot", function(inst)
    if GetPlayer().prefab ~= "wond" then return end

    inst.inmagic = false
    inst.product_spec = false

    inst.onmagic = function(inst, inmagic)
        inst.inmagic = inmagic
        local colour = inmagic and GLOBAL.Vector3(0.2, 0.04, 0) or GLOBAL.Vector3(0, 0, 0)
        inst.AnimState:SetAddColour(colour.x, colour.y, colour.z, 0)
        inst.useraddcolour = colour
    end

    local continuedonefn = inst.components.stewer.oncontinuedone
    local donecookfn = inst.components.stewer.ondonecooking
    local harvestfn = inst.components.stewer.onharvest
    local spoilfn = inst.components.stewer.onspoil

    inst.components.stewer.ondonecooking = function(inst)                
        inst.product_spec = GetPlayer().components.foodspec:Cooking(inst.components.stewer.product, inst.inmagic)
        inst:onmagic(false)
        if inst.product_spec then
            inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
        end
        donecookfn(inst)
    end
    inst.components.stewer.oncontinuedone = function(inst)
        if inst.product_spec and not inst:HasTag("burnt") then
            inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
        end
        continuedonefn(inst)
    end
    inst.components.stewer.onharvest = function(inst)
        inst.AnimState:SetBloomEffectHandle( "" )
        if inst.product_spec and inst.components.stewer.product and inst.components.stewer.product ~= "spoiledfood" then
            inst.components.stewer.product = inst.components.stewer.product .. "_spec"                
        end        
        harvestfn(inst)
        inst.product_spec = false
    end
    inst.components.stewer.onspoil = function(inst)
        inst.AnimState:SetBloomEffectHandle( "" )
        inst.product_spec = false
        spoilfn(inst) 
    end

    local onsave = inst.OnSave
    local onload = inst.OnLoad

    inst.OnSave = function(inst, data)
        onsave(inst, data)
        data.inmagic = inst.inmagic
        data.product_spec = inst.product_spec
    end

    inst.OnLoad = function(inst, data)
        onload(inst, data)
        if data and data.inmagic then
            inst:onmagic(true)
        end
        if data and data.product_spec then
            inst.product_spec = data.product_spec
            if not inst:HasTag("burnt") then
                inst.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
            end
        end
    end
end)

-- patching "components/combat"
local Combat = require("components/combat")
local oldgetattacked = Combat.GetAttacked
function Combat:GetAttacked(attacker, damage, weapon)
    local factor = 1 - (self.damagereduce or 0)
    return oldgetattacked(self, attacker, damage * factor, weapon)    
end

-- patching "components/eater"
local Eater = require("components/eater")
local oldcaneat = Eater.CanEat
function Eater:CanEat(food)
    local caneat = oldcaneat(self, food)
    if caneat and self.inst.prefab == "wond" and food.components.perishable then        
        return food.components.perishable:IsFresh()
    end
    return caneat
end

-- patching "components/hounded"
local Hounded = require("components/hounded")
local oldplanattack = Hounded.PlanNextHoundAttack
function Hounded:PlanNextHoundAttack()
    oldplanattack(self)
    self.houndstorelease = self.houndstorelease + (self.bonus or 0)
end


-- patching "widgets/itemtitle"

local ItemTile = require("widgets/itemtile")
local oldoncontrol = ItemTile.OnControl
local oldongainfocus = ItemTile.OnGainFocus

function ItemTile:AppendSpecialFoodTip()
    if self.item and self.item.components.inventoryitem then
        if self.item:HasTag("specfood") then
            local basefood = string.sub(self.item.prefab, 1, string.find(self.item.prefab, "_") - 1)
            local str = string.format(STRINGS.WOND_COOKRATE_STRING, GetPlayer().components.foodspec.foods[basefood].chance * 100)
            self:SetTooltip(self.tooltip .. "\n" .. str)
        end
    end
end


function ItemTile:OnControl(control, down)
    oldoncontrol(self, control, down)
    if control == GLOBAL.CONTROL_FORCE_INSPECT and down then
        self:AppendSpecialFoodTip()
    end
end

function ItemTile:OnGainFocus()
    oldongainfocus(self)
    if GLOBAL.TheInput:IsControlPressed(GLOBAL.CONTROL_FORCE_INSPECT) then
        self:AppendSpecialFoodTip()
    end
end
