SPEC_MONSTER = 0

SPEC_HEALTH = 1
SPEC_HUNGER = 2
SPEC_SANITY = 3 
SPEC_WEAPON = 4

SPEC_DAMAGE = 5
SPEC_MOVESPEED = 6
SPEC_PROTECTION = 7
SPEC_WILL = 8

SPEC_MAX = 8

local spectext =
{
   [SPEC_MONSTER] = STRINGS.WOND_SPEC_MONSTER,
   [SPEC_HEALTH] = STRINGS.WOND_SPEC_HEALTH,
   [SPEC_HUNGER] = STRINGS.WOND_SPEC_HUNGER,
   [SPEC_SANITY] = STRINGS.WOND_SPEC_SANITY,
   [SPEC_WEAPON] = STRINGS.WOND_SPEC_WEAPON,
   [SPEC_DAMAGE] = STRINGS.WOND_SPEC_DAMAGE,
   [SPEC_MOVESPEED] = STRINGS.WOND_SPEC_MOVESPEED,
   [SPEC_PROTECTION] = STRINGS.WOND_SPEC_PROTECTION,
   [SPEC_WILL] = STRINGS.WOND_SPEC_WILL,
}

local specfoodinit =
{
    monsterlasagna =    {   type = SPEC_MONSTER,    chance = .5,    min_chance = .5, },     -- ǧ
    
    meatballs =         {   type = SPEC_HEALTH,     chance = .55,   min_chance = .065, },    --    
    bonestew =          {   type = SPEC_HEALTH,     chance = .65,   min_chance = .065, },    -- 
    fishtacos =         {   type = SPEC_HEALTH,     chance = .45,   min_chance = .08, },   -- ī
    fishsticks =        {   type = SPEC_HEALTH,     chance = .65,   min_chance = .065, },    -- 
	frogglebunwich =    {   type = SPEC_HEALTH,     chance = .55,   min_chance = .065, },    -- ȹ

    honeyham =          {   type = SPEC_HUNGER,     chance = .65,   min_chance = .08, },    -- ֭
    honeynuggets =      {   type = SPEC_HUNGER,     chance = .5,    min_chance = .08, },    -- ֭
    baconeggs =         {   type = SPEC_HUNGER,     chance = .4,    min_chance = .065, },   -- 
	perogies =          {   type = SPEC_HUNGER,     chance = .45,   min_chance = .065, },   -- ˮ

    watermelonicle =    {   type = SPEC_SANITY,     chance = .65,   min_chance = .1, },     -- 
  	trailmix =          {   type = SPEC_SANITY,     chance = .55,   min_chance = .08, },    -- ӻ
	jammypreserves =    {   type = SPEC_SANITY,     chance = .45,   min_chance = .065, },   -- 	
	
    turkeydinner =      {   type = SPEC_WEAPON,     chance = .65,   min_chance = .08, },    -- 𼦴
	unagi =             {   type = SPEC_WEAPON,     chance = .45,   min_chance = .08, },    -- ˾
    butterflymuffin =   {   type = SPEC_WEAPON,     chance = .45,   min_chance = .05, },    -- ʵɱ
    powcake =           {   type = SPEC_WEAPON,     chance = .55,   min_chance = .065, },   -- ۱
    icecream =          {   type = SPEC_WEAPON,     chance = .65,   min_chance = .1, },     -- 
    
    dragonpie =         {   type = SPEC_DAMAGE,     chance = .55,   min_chance = .08, },    -- 
    taffy =             {   type = SPEC_DAMAGE,     chance = .45,   min_chance = .065, },   -- ̫
	fruitmedley =       {   type = SPEC_DAMAGE,     chance = .55,   min_chance = .08, },    -- ˮʥ
 
    mandrakesoup =      {   type = SPEC_MOVESPEED,  chance = 1,     min_chance = .25, },    -- 
    waffles =           {   type = SPEC_MOVESPEED,  chance = .65,   min_chance = .18, },    -- 
    flowersalad =       {   type = SPEC_MOVESPEED,  chance = .4,    min_chance = .065, },   -- ʻɫ
    ratatouille =       {   type = SPEC_MOVESPEED,  chance = .15,   min_chance = .04, },    -- ʲ

    guacamole =         {   type = SPEC_PROTECTION, chance = .55,   min_chance = .08, },    -- ɫ
    stuffedeggplant =   {   type = SPEC_PROTECTION, chance = .5,    min_chance = .08, },    -- Ѻ
    kabobs =            {   type = SPEC_PROTECTION, chance = .4,    min_chance = .05, },    -- 

    pumpkincookie =     {   type = SPEC_WILL,       chance = .6,    min_chance = .09, },    -- Ϲϱ
	hotchili =          {   type = SPEC_WILL,       chance = .5,    min_chance = .09, },    -- 

    --wetgoop
}


local FoodSpec = Class(function(self, inst)
    self.inst = inst
    self.foods = specfoodinit
    self.bonus = {}
end)

function FoodSpec:OnSave()
    local chancetbl = {}
    for k, v in pairs(self.foods) do
        chancetbl[k] = v.chance
    end
    return {
        chance = chancetbl,
        bonus = self.bonus,
        attr = {
            health = self.inst.components.health.currenthealth,
            hunger = self.inst.components.hunger.current,
            sanity = self.inst.components.sanity.current,
        },
    }
end

function FoodSpec:OnLoad(data)
    if data then
        for k, v in pairs(data.chance) do
            self.foods[k].chance = v
        end
        for k, v in pairs(data.bonus) do
            self:ApplyBonus(k, v, false)
        end
        if data.attr then
            self.inst.components.health.currenthealth = data.attr.health
            self.inst.components.hunger.current = data.attr.hunger
            self.inst.components.sanity.current = data.attr.sanity
        end
    end
end

function FoodSpec:ApplyBonus(idx, lvl, grow)
    if idx < 0 or idx > SPEC_MAX then return end
    --print("FoodSpec: " .. spectext[idx] .. " set rank " .. lvl)

    local b = lvl

    if idx == SPEC_HEALTH then
        self.inst.components.health.maxhealth = TUNING.WOND_BASE_HEALTH + b * 5
        if grow then
            self.inst.components.health:DoDelta(5)
        else
            self.inst.components.health:DoDelta(0)
        end
    elseif idx == SPEC_HUNGER then
        self.inst.components.hunger.max = TUNING.WOND_BASE_HUNGER + b * 5
        if grow then
            self.inst.components.hunger:DoDelta(5)
        else
            self.inst.components.hunger:DoDelta(0)
        end
    elseif idx == SPEC_SANITY then
        self.inst.components.sanity.max = TUNING.WOND_BASE_SANITY + b * 5
        if grow then
            self.inst.components.sanity:DoDelta(5)
        else
            self.inst.components.sanity:DoDelta(0)
        end
    elseif idx == SPEC_WEAPON then
        self.inst.components.combat.damagemultiplier = TUNING.WOND_BASE_DAMAGE_MULT + b * 0.02
    elseif idx == SPEC_DAMAGE then
        b = math.clamp(b, 0, 50)
        self.inst.components.combat.damagebonus = b 
    elseif idx == SPEC_MOVESPEED then
        b = math.clamp(b, 0, 30)
		self.inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED * (1 + b * 0.02)
		self.inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED * (1 + b * 0.02)        
    elseif idx == SPEC_PROTECTION then
        b = math.clamp(b, 0, 50)
        self.inst.components.combat.damagereduce = b * 0.06 / (1 + b * 0.06)
    elseif idx == SPEC_WILL then
        b = math.clamp(b, 0, 30)
        self.inst.components.sanity.dapperness = TUNING.DAPPERNESS_HUGE / 30 * b
    elseif idx == SPEC_MONSTER then
        GetWorld().components.hounded.houndstorelease = GetWorld().components.hounded.houndstorelease + 1
        GetWorld().components.hounded.bonus = b
    end

    self.bonus[idx] = b    
    return b == lvl
end


function FoodSpec:Cooking(prefab, inmagic)
    if self.foods[prefab] then
        local chance = self.foods[prefab].chance        
        if inmagic then chance = chance * 2 end
        local r = math.random()
        print(string.format("r = %.3f, c = %.3f", r, chance))
        if r < chance then          
            self.foods[prefab].chance = math.clamp(self.foods[prefab].chance * TUNING.SPECFOOD_CHANCE_DROP, self.foods[prefab].min_chance, 1)
            --print(string.format("FoodSpec: %s, magic: %s, %.3f -> %.3f", prefab, tostring(inmagic), chance, self.foods[prefab].chance))
            return true
        end
    end
    return false
end

function FoodSpec:OnEat(food)
    local basefood = string.sub(food.prefab, 1, string.find(food.prefab, "_") - 1)
    if self.foods[basefood] then
        local idx = self.foods[basefood].type
        local promoted = self:ApplyBonus(idx, (self.bonus[idx] or 0) + 1, true) 
        self:BonusEffect(idx, promoted)
    end
end


local FollowText = require "widgets/followtext"
local function floatingtextfn(inst, text, time, colour, size, start_offset, end_offset)
    local widget = GetPlayer().HUD:AddChild(FollowText(TALKINGFONT, size or 35))
    local soff = start_offset or Vector3(0, -400, 0)
    local eoff = end_offset or Vector3(0, -700, 0)
    widget:SetOffset(soff)
    widget:SetTarget(inst)

    local clr = colour or Vector3(1, 1, 1)
    widget.text:SetColour(clr.x, clr.y, clr.z, 1)   
    widget.text:SetString(text)

    local start_time = GetTime()
    while true do
        local t = GetTime()            
        local percent = (t - start_time) / time
        if percent > 1 then
            break
        end
        widget.offset = soff + (eoff - soff) * percent
        widget.text:SetColour(clr.x, clr.y, clr.z, 1 - percent * percent)   
        Yield()
    end
    widget:Kill()    
end

function FoodSpec:BonusEffect(idx, promoted)
    local clr_talk = self.inst.components.talker.colour
    self.inst.components.talker.ignoring = false
    if promoted then
        local limit = -1
        if idx == SPEC_DAMAGE or idx == SPEC_MOVESPEED or idx == SPEC_PROTECTION then
            limit = 50
        elseif idx == SPEC_WILL then
            limit = 30
        end
        local rankuptext = spectext[idx] .. STRINGS.WOND_RANKUP_STRING .. self.bonus[idx]
        if limit ~= -1 then
            rankuptext = rankuptext .. "/" .. limit
        end
        self.inst.AnimState:PlayAnimation("staff")
        self.inst.SoundEmitter:PlaySound("dontstarve/common/makeFriend")                 
        self.inst:StartThread( function()
            floatingtextfn(self.inst, rankuptext, 2.5, (idx == SPEC_MONSTER) and Vector3(1, 76/255, 0) or Vector3(238/255, 201/255, 0), 32)
        end)    
    else        
        self.inst.components.talker:Say(STRINGS.WOND_NOEFFECT_STRING)  
    end
end

return FoodSpec