local assets =
{
	Asset("ANIM", "anim/books.zip"),
}

function magicfn(inst, reader)
    if reader.prefab ~= "wond" then return end

    reader.components.sanity:DoDelta(-TUNING.SANITY_MEDLARGE)
    local range = 30
    local pos = Vector3(reader.Transform:GetWorldPosition())
    local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, range)
    for k,v in pairs(ents) do
        if v.prefab == "cookpot" then
            v:onmagic(true)
        end
    end
    return true
end

function onfinished(inst)
    inst:Remove()
end

function MakeBook(name, art, usefn, bookuses )

    local function fn(Sim)
    	local inst = CreateEntity()
    	local trans = inst.entity:AddTransform()
    	local anim = inst.entity:AddAnimState()
        local sound = inst.entity:AddSoundEmitter()
        anim:SetBank("books")
        anim:SetBuild("books")

        anim:PlayAnimation(art)
        MakeInventoryPhysics(inst)
        
        -----------------------------------
        
        inst:AddComponent("inspectable")
        inst:AddComponent("book")
        inst.components.book.onread = usefn

        inst:AddComponent("characterspecific")
        inst.components.characterspecific:SetOwner("wond")
        
        inst:AddComponent("inventoryitem")
        inst.components.inventoryitem.imagename = art

        inst:AddComponent("finiteuses")
        inst.components.finiteuses:SetMaxUses( bookuses )
        inst.components.finiteuses:SetUses( bookuses )
        inst.components.finiteuses:SetOnFinished( onfinished )

        MakeSmallBurnable(inst)
        MakeSmallPropagator(inst)

        return inst
    end

    return Prefab( "common/"..name, fn, assets, {}) 
end

return MakeBook("book_cookmagic", "book_brimstone", magicfn, 5)   