local MakePlayerCharacter = require "prefabs/player_common"

local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/wond.zip" ),
}
local prefabs = {}


local fn = function(inst)

	-- choose which sounds this character will play
	inst.soundsname = "willow"

	-- a minimap icon must be specified
	inst.MiniMapEntity:SetIcon("wond.tex")

    inst.components.health:SetMaxHealth(TUNING.WOND_BASE_HEALTH)
    inst.components.hunger:SetMax(TUNING.WOND_BASE_HUNGER)
    inst.components.sanity:SetMax(TUNING.WOND_BASE_SANITY)
    inst.components.combat.damagemultiplier = TUNING.WOND_BASE_DAMAGE_MULT
    inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1.5)
    
    inst:AddComponent("foodspec")

    inst:ListenForEvent("oneat", function(inst, data)
        if data and data.food then
            if data.food:HasTag("specfood") then
                inst.components.foodspec:OnEat(data.food)
            end
        end
    end)

    inst:AddComponent("reader")

	local booktab = {str = STRINGS.TABS.BOOKS, sort=999, icon = "tab_book.tex"}
	inst.components.builder:AddRecipeTab(booktab)

	local recipe = Recipe("book_cookmagic", {Ingredient("papyrus", 1), Ingredient("purplegem", 1)}, booktab, {SCIENCE = 0, MAGIC = 0, ANCIENT = 0})
    recipe.image = "book_brimstone.tex"

    inst.components.builder:UnlockRecipe("cookpot")
    inst.components.builder:UnlockRecipe("icebox")
    inst.components.builder:BufferBuild("cookpot")
    inst.components.builder:BufferBuild("icebox")
	return inst
end

return MakePlayerCharacter("wond", prefabs, assets, fn, {"meat", "meat", "meat", "meat", "meat", "meat"})
