/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import se.llbit.json.Json;
import se.llbit.json.JsonMember;
import se.llbit.json.JsonNumber;
import se.llbit.json.JsonObject;
import se.llbit.json.JsonParser;
import se.llbit.json.JsonString;
import se.llbit.json.JsonValue;
import se.llbit.json.PrettyPrinter;
import se.llbit.log.Log;

public final class JsonSettings {
    private JsonObject json = new JsonObject();

    public void load(File file) {
        String path = file.getAbsolutePath();
        try (FileInputStream in = new FileInputStream(file);){
            JsonParser parser = new JsonParser(in);
            this.json = parser.parse().object();
            Log.infof("Settings loaded from %s", path);
        }
        catch (IOException e) {
            Log.warnf("Warning: Could not load settings from %s - defaults will be used", path);
        }
        catch (JsonParser.SyntaxError e) {
            Log.warnf("Warning: Could not load settings from %s - defaults will be used (%s)", path, e.getMessage());
        }
    }

    public void save(File settingsDir, File file) {
        if (file == null) {
            Log.error("Can't save settings: null file");
            return;
        }
        if (settingsDir == null && (settingsDir = file.getParentFile()) == null) {
            Log.error("Can't save settings to file: " + file.getAbsolutePath());
            return;
        }
        if (!settingsDir.isDirectory()) {
            Log.warn("Warning: Chunky settings directory does not exist. Creating settings directory at " + settingsDir.getAbsolutePath());
            boolean success = settingsDir.mkdirs();
            if (!success) {
                Log.error("Failed to create settings directory " + settingsDir.getAbsolutePath());
                return;
            }
        }
        try {
            FileOutputStream out = new FileOutputStream(file);
            PrettyPrinter pp = new PrettyPrinter("  ", new PrintStream(out));
            this.json.prettyPrint(pp);
            ((OutputStream)out).close();
            Log.info("Saved settings to " + file.getAbsolutePath());
        }
        catch (IOException e) {
            Log.warnf("Warning: Failed to save settings to %s: %s", file.getAbsolutePath(), e.getMessage());
        }
    }

    public String getString(String name, String defValue) {
        return this.json.get(name).stringValue(defValue);
    }

    public JsonValue get(String name) {
        return this.json.get(name);
    }

    public void set(String name, JsonValue value) {
        this.json.set(name, value);
    }

    public boolean getBool(String name, boolean defValue) {
        return this.json.get(name).boolValue(defValue);
    }

    public int getInt(String name, int defValue) {
        return this.json.get(name).intValue(defValue);
    }

    public double getDouble(String name, double defValue) {
        return this.json.get(name).doubleValue(defValue);
    }

    public void setString(String name, String value) {
        this.json.set(name, (JsonValue)new JsonString(value));
    }

    public void setBool(String name, boolean value) {
        this.json.set(name, Json.of(value));
    }

    public void setInt(String name, int value) {
        this.json.set(name, (JsonValue)new JsonNumber("" + value));
    }

    public void setDouble(String name, double value) {
        this.json.set(name, (JsonValue)new JsonNumber("" + value));
    }

    public void removeSetting(String name) {
        this.json.remove(name);
    }

    public boolean containsKey(String name) {
        for (JsonMember entry : this.json) {
            if (!entry.name.equals(name)) continue;
            return true;
        }
        return false;
    }
}

