/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky;

import java.io.File;
import se.llbit.chunky.JsonSettings;
import se.llbit.chunky.renderer.RenderConstants;
import se.llbit.chunky.resources.SettingsDirectory;
import se.llbit.json.JsonArray;
import se.llbit.json.JsonValue;

public final class PersistentSettings {
    public static JsonSettings settings = new JsonSettings();
    public static final String SETTINGS_FILE = "chunky.json";
    public static final String DEFAULT_SCENE_DIRECTORY_NAME = "scenes";
    public static final double DEFAULT_WATER_OPACITY = 0.42;
    public static final double DEFAULT_WATER_VISIBILITY = 9.0;
    public static final int DEFAULT_WATER_HEIGHT = 0;
    public static final double DEFAULT_WATER_RED = 0.03;
    public static final double DEFAULT_WATER_GREEN = 0.13;
    public static final double DEFAULT_WATER_BLUE = 0.16;
    private static final double WAVELENGTH_RED = 650.0;
    private static final double WAVELENGTH_GREEN = 570.0;
    private static final double WAVELENGTH_BLUE = 475.0;
    public static final double W = Math.pow(0.475, 4.0);
    public static final double RM = 0.2;
    public static final double DEFAULT_FOG_RED = 0.2 + 0.8 * W * Math.pow(0.65, -4.0);
    public static final double DEFAULT_FOG_GREEN = 0.2 + 0.8 * W * Math.pow(0.57, -4.0);
    public static final double DEFAULT_FOG_BLUE = 1.0;
    public static final int DEFAULT_RAY_DEPTH = 5;
    public static final int DEFAULT_SPP_TARGET = 1000;
    public static final int DEFAULT_DIMENSION = 0;
    public static final int DEFAULT_3D_CANVAS_WIDTH = 400;
    public static final int DEFAULT_3D_CANVAS_HEIGHT = 400;
    private static File settingsDir;
    private static File cacheDir;
    private static File settingsFile;

    private PersistentSettings() {
    }

    private static void save() {
        settings.save(settingsDir, settingsFile);
    }

    public static File settingsDirectory() {
        return settingsDir;
    }

    public static File cacheDirectory() {
        return cacheDir;
    }

    public static File getSceneDirectory() {
        String defaultPath = new File(settingsDir, DEFAULT_SCENE_DIRECTORY_NAME).getAbsolutePath();
        return new File(settings.getString("sceneDirectory", defaultPath));
    }

    public static int getNumThreads() {
        return settings.getInt("numThreads", RenderConstants.NUM_RENDER_THREADS_DEFAULT);
    }

    public static void setNumRenderThreads(int numThreads) {
        numThreads = Math.max(1, numThreads);
        numThreads = Math.min(10000, numThreads);
        settings.setInt("numThreads", numThreads);
        PersistentSettings.save();
    }

    public static void setYClipMax(int value) {
        settings.setInt("yClipMax", value);
        PersistentSettings.save();
    }

    public static int getYClipMax() {
        return settings.getInt("yClipMax", 256);
    }

    public static void setYClipMin(int value) {
        settings.setInt("yClipMin", value);
        PersistentSettings.save();
    }

    public static int getYClipMin() {
        return settings.getInt("yClipMin", 0);
    }

    public static int getCPULoad() {
        return settings.getInt("cpuLoad", 100);
    }

    public static void setCPULoad(int cpuLoad) {
        cpuLoad = Math.max(1, cpuLoad);
        cpuLoad = Math.min(100, cpuLoad);
        settings.setInt("cpuLoad", cpuLoad);
        PersistentSettings.save();
    }

    public static void setLastWorld(File worldDirectory) {
        settings.setString("lastWorld", worldDirectory.getAbsolutePath());
        PersistentSettings.save();
    }

    public static File getLastWorld() {
        String lastWorld = settings.getString("lastWorld", "");
        return lastWorld.isEmpty() ? null : new File(lastWorld);
    }

    public static void setSkinDirectory(File directory) {
        settings.setString("skinDirectory", directory.getAbsolutePath());
        PersistentSettings.save();
    }

    public static String getSkinDirectory() {
        return settings.getString("skinDirectory", "");
    }

    public static String getLastTexturePack() {
        return settings.getString("lastTexturePack", "");
    }

    public static void setRayDepth(int rayDepth) {
        settings.setInt("rayDepth", rayDepth);
        PersistentSettings.save();
    }

    public static int getSppTargetDefault() {
        return settings.getInt("sppTargetDefault", 1000);
    }

    public static int getRayDepthDefault() {
        return settings.getInt("rayDepth", 5);
    }

    public static int get3DCanvasHeight() {
        return settings.getInt("3dcanvas.height", 400);
    }

    public static int get3DCanvasWidth() {
        return settings.getInt("3dcanvas.width", 400);
    }

    public static void setSceneDirectory(File dir) {
        settings.setString("sceneDirectory", dir.getAbsolutePath());
        PersistentSettings.save();
    }

    public static boolean containsKey(String key) {
        return settings.containsKey(key);
    }

    public static void setSppTargetDefault(int targetSPP) {
        settings.setInt("sppTargetDefault", targetSPP);
        PersistentSettings.save();
    }

    public static void set3DCanvasSize(int width, int height) {
        settings.setInt("3dcanvas.width", width);
        settings.setInt("3dcanvas.height", height);
        PersistentSettings.save();
    }

    public static void setLastTexturePack(String path) {
        settings.setString("lastTexturePack", path);
        PersistentSettings.save();
    }

    public static String getMinecraftDirectory() {
        return settings.getString("minecraftDir", "");
    }

    public static void setMinecraftDirectory(String path) {
        settings.setString("minecraftDir", path);
        PersistentSettings.save();
    }

    public static void setStringOption(String name, String value) {
        settings.setString(name, value);
        PersistentSettings.save();
    }

    public static void setIntOption(String name, int value) {
        settings.setInt(name, value);
        PersistentSettings.save();
    }

    public static void resetOption(String name) {
        settings.removeSetting(name);
        PersistentSettings.save();
    }

    public static boolean getFollowPlayer() {
        return settings.getBool("followPlayer", false);
    }

    public static void setFollowPlayer(boolean value) {
        settings.setBool("followPlayer", value);
        PersistentSettings.save();
    }

    public static boolean getFollowCamera() {
        return settings.getBool("followCamera", false);
    }

    public static void setFollowCamera(boolean value) {
        settings.setBool("followCamera", value);
        PersistentSettings.save();
    }

    public static void setStillWater(boolean value) {
        settings.setBool("stillWater", value);
        PersistentSettings.save();
    }

    public static boolean getStillWater() {
        return settings.getBool("stillWater", false);
    }

    public static void setWaterOpacity(double value) {
        settings.setDouble("waterOpacity", value);
        PersistentSettings.save();
    }

    public static double getWaterOpacity() {
        return settings.getDouble("waterOpacity", 0.42);
    }

    public static void setWaterVisibility(double value) {
        settings.setDouble("waterVisibility", value);
        PersistentSettings.save();
    }

    public static double getWaterVisibility() {
        return settings.getDouble("waterVisibility", 9.0);
    }

    public static void setWaterHeight(int value) {
        settings.setInt("waterHeight", value);
        PersistentSettings.save();
    }

    public static int getWaterHeight() {
        return settings.getInt("waterHeight", 0);
    }

    public static void setUseCustomWaterColor(boolean value) {
        settings.setBool("useCustomWaterColor", value);
        PersistentSettings.save();
    }

    public static boolean getUseCustomWaterColor() {
        return settings.getBool("useCustomWaterColor", false);
    }

    public static void setWaterColor(double red, double green, double blue) {
        settings.setDouble("waterColorRed", red);
        settings.setDouble("waterColorGreen", green);
        settings.setDouble("waterColorBlue", blue);
        PersistentSettings.save();
    }

    public static double getWaterColorRed() {
        return settings.getDouble("waterColorRed", 0.03);
    }

    public static double getWaterColorGreen() {
        return settings.getDouble("waterColorGreen", 0.13);
    }

    public static double getWaterColorBlue() {
        return settings.getDouble("waterColorBlue", 0.16);
    }

    public static void setFogColor(double red, double green, double blue) {
        settings.setDouble("fogColorRed", red);
        settings.setDouble("fogColorGreen", green);
        settings.setDouble("fogColorBlue", blue);
        PersistentSettings.save();
    }

    public static double getFogColorRed() {
        return settings.getDouble("fogColorRed", DEFAULT_FOG_RED);
    }

    public static double getFogColorGreen() {
        return settings.getDouble("fogColorGreen", DEFAULT_FOG_GREEN);
    }

    public static double getFogColorBlue() {
        return settings.getDouble("fogColorBlue", 1.0);
    }

    public static void setSingleColorTextures(boolean value) {
        settings.setBool("singleColorTextures", value);
        PersistentSettings.save();
    }

    public static boolean getSingleColorTextures() {
        return settings.getBool("singleColorTextures", false);
    }

    public static void setDimension(int value) {
        settings.setInt("dimension", value);
        PersistentSettings.save();
    }

    public static int getDimension() {
        return settings.getInt("dimension", 0);
    }

    public static boolean getLoadPlayers() {
        return settings.getBool("loadPlayers", true);
    }

    public static void setLoadPlayers(boolean value) {
        settings.setBool("loadPlayers", value);
        PersistentSettings.save();
    }

    public static boolean drawUnknownBlocks() {
        return settings.getBool("drawUnknownBlocks", false);
    }

    public static JsonArray getPlugins() {
        return settings.get("plugins").array();
    }

    public static void setPlugins(JsonValue value) {
        settings.set("plugins", value);
        PersistentSettings.save();
    }

    public static void changeSettingsDirectory(File directory) {
        settingsDir = directory;
        settingsFile = new File(settingsDir, SETTINGS_FILE);
        cacheDir = new File(settingsDir, "cache");
        settings.load(settingsFile);
    }

    static {
        File directory = SettingsDirectory.getSettingsDirectory();
        if (directory == null) {
            directory = SettingsDirectory.getHomeDirectory();
        }
        PersistentSettings.changeSettingsDirectory(directory);
    }
}

