/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.launcher;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.util.Scanner;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javafx.stage.Stage;
import se.llbit.chunky.launcher.ChunkyDeployer;
import se.llbit.chunky.launcher.ConsoleLogger;
import se.llbit.chunky.launcher.ConsoleUpdater;
import se.llbit.chunky.launcher.DownloadStatus;
import se.llbit.chunky.launcher.LaunchMode;
import se.llbit.chunky.launcher.LauncherSettings;
import se.llbit.chunky.launcher.UpdateChecker;
import se.llbit.chunky.launcher.UpdateListener;
import se.llbit.chunky.launcher.VersionInfo;
import se.llbit.chunky.launcher.ui.ChunkyLauncherFx;
import se.llbit.chunky.launcher.ui.DebugConsole;
import se.llbit.chunky.launcher.ui.FirstTimeSetupDialog;
import se.llbit.chunky.resources.SettingsDirectory;

public class ChunkyLauncher {
    public static final String LAUNCHER_VERSION = "v1.11.2";

    protected static void launchFailure(String command) {
        System.out.println("Failed to launch Chunky. Command used:");
        System.out.println(command);
    }

    public static void main(String[] args) throws FileNotFoundException {
        final LauncherSettings settings = new LauncherSettings();
        settings.load();
        boolean forceLauncher = false;
        LaunchMode mode = LaunchMode.GUI;
        String headlessOptions = "";
        if (args.length > 0) {
            mode = LaunchMode.HEADLESS;
            String[] stringArray = args;
            int n = stringArray.length;
            block19: for (int i = 0; i < n; ++i) {
                String arg;
                switch (arg = stringArray[i]) {
                    case "--nolauncher": {
                        mode = LaunchMode.GUI;
                        continue block19;
                    }
                    case "--launcher": {
                        forceLauncher = true;
                        continue block19;
                    }
                    case "--version": {
                        System.out.println("Chunky Launcher v1.11.2");
                        return;
                    }
                    case "--verbose": {
                        settings.verboseLauncher = true;
                        continue block19;
                    }
                    case "--console": {
                        settings.forceGuiConsole = true;
                        continue block19;
                    }
                    case "--update": 
                    case "--updateAlpha": {
                        if (arg.equals("--updateAlpha")) {
                            System.out.println("Checking for Chunky alpha/snapshot updates..");
                            settings.downloadSnapshots = true;
                        } else {
                            System.out.println("Checking for updates..");
                        }
                        UpdateChecker updateThread = new UpdateChecker(settings, new UpdateListener(){

                            @Override
                            public void updateError(String message) {
                            }

                            @Override
                            public void updateAvailable(VersionInfo latest) {
                                try {
                                    ChunkyLauncher.headlessCreateSettingsDirectory();
                                }
                                catch (FileNotFoundException e) {
                                    throw new Error(e);
                                }
                                System.out.println("Downloading Chunky " + latest + ":");
                                ConsoleUpdater.update(latest, settings);
                            }

                            @Override
                            public void noUpdateAvailable() {
                                System.out.println("No updates found.");
                                if (!settings.downloadSnapshots) {
                                    System.out.println("Alpha/snapshot updates are disabled, enable with --updateAlpha");
                                }
                            }
                        });
                        updateThread.start();
                        return;
                    }
                    case "--setup": {
                        ChunkyLauncher.doSetup(settings);
                        settings.save();
                        return;
                    }
                    default: {
                        if (!headlessOptions.isEmpty()) {
                            headlessOptions = headlessOptions + " ";
                        }
                        headlessOptions = headlessOptions + arg;
                    }
                }
            }
            if (forceLauncher) {
                mode = LaunchMode.GUI;
            }
        }
        ChunkyDeployer.LoggerBuilder loggerBuilder = () -> {
            if (settings.forceGuiConsole || !settings.headless && settings.debugConsole) {
                AtomicReference<Object> console = new AtomicReference<Object>(null);
                CountDownLatch latch = new CountDownLatch(1);
                ChunkyLauncherFx.withLauncher(settings, stage -> {
                    DebugConsole debugConsole = new DebugConsole(settings.closeConsoleOnExit);
                    debugConsole.show();
                    console.set(debugConsole);
                    latch.countDown();
                });
                try {
                    latch.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return console.get();
            }
            return new ConsoleLogger();
        };
        if (mode == LaunchMode.HEADLESS) {
            ChunkyLauncher.headlessCreateSettingsDirectory();
            settings.debugConsole = true;
            settings.headless = true;
            settings.chunkyOptions = headlessOptions;
            ChunkyDeployer.deploy(settings);
            VersionInfo version = ChunkyDeployer.resolveVersion(settings.version);
            if (ChunkyDeployer.canLaunch(version, null, false)) {
                int exitCode = ChunkyDeployer.launchChunky(settings, version, LaunchMode.HEADLESS, ChunkyLauncher::launchFailure, loggerBuilder);
                if (exitCode != 0) {
                    System.exit(exitCode);
                }
            } else {
                System.err.println("Could not launch selected Chunky version. Try updating with --update");
                System.exit(1);
            }
        } else {
            boolean finalForceLauncher = forceLauncher;
            ChunkyLauncher.firstTimeSetup(settings, () -> {
                VersionInfo version;
                ChunkyDeployer.deploy(settings);
                return finalForceLauncher || settings.showLauncher || !ChunkyDeployer.canLaunch(version = ChunkyDeployer.resolveVersion(settings.version), null, false) || ChunkyDeployer.launchChunky(settings, version, LaunchMode.GUI, ChunkyLauncher::launchFailure, loggerBuilder) != 0;
            });
        }
    }

    private static void headlessCreateSettingsDirectory() throws FileNotFoundException {
        File directory = SettingsDirectory.getSettingsDirectory();
        if (directory == null || !directory.isDirectory()) {
            System.out.println("Chunky settings directory not found - trying to create one.");
            if (directory != null && !directory.mkdir()) {
                System.out.format("Failed to create directory: %s%n", directory.getAbsolutePath());
            }
            if (!(directory != null && directory.isDirectory() || (directory = SettingsDirectory.getHomeDirectory()) == null || directory.mkdir())) {
                System.out.format("Failed to create directory: %s%n", directory.getAbsolutePath());
            }
            if (directory != null && directory.isDirectory()) {
                System.out.format("Created settings directory: %s%n", directory.getAbsolutePath());
            }
        }
        if (directory != null) {
            Throwable throwable;
            PrintStream out;
            File settingsFile = new File(directory, "chunky.json");
            if (!settingsFile.exists()) {
                out = new PrintStream(new FileOutputStream(settingsFile));
                throwable = null;
                try {
                    out.println("{}");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
            if (!(settingsFile = new File(directory, "chunky-launcher.json")).exists()) {
                out = new PrintStream(new FileOutputStream(settingsFile));
                throwable = null;
                try {
                    out.println("{}");
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    if (out != null) {
                        if (throwable != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            out.close();
                        }
                    }
                }
            }
        }
    }

    private static void doSetup(LauncherSettings settings) throws FileNotFoundException {
        ChunkyLauncher.headlessCreateSettingsDirectory();
        System.out.print("Memory limit (MiB): ");
        Scanner in = new Scanner(System.in);
        settings.memoryLimit = in.nextInt();
        in.nextLine();
        System.out.print("Java options: ");
        settings.javaOptions = in.nextLine();
    }

    private static void firstTimeSetup(LauncherSettings settings, ShowLauncher afterFirstTimeSetup) {
        if (SettingsDirectory.findSettingsDirectory()) {
            if (afterFirstTimeSetup.showLauncher()) {
                ChunkyLauncherFx.withLauncher(settings, Stage::show);
            }
        } else {
            ChunkyLauncherFx.withLauncher(settings, stage -> {
                FirstTimeSetupDialog picker = new FirstTimeSetupDialog(() -> {
                    if (afterFirstTimeSetup.showLauncher()) {
                        stage.show();
                    }
                });
                picker.show();
            });
        }
    }

    public static DownloadStatus tryDownload(File libDir, VersionInfo.Library lib, String theUrl) {
        try {
            URL url = new URL(theUrl);
            ReadableByteChannel inChannel = Channels.newChannel(url.openStream());
            FileOutputStream out = new FileOutputStream(lib.getFile(libDir));
            out.getChannel().transferFrom(inChannel, 0L, Long.MAX_VALUE);
            out.close();
            VersionInfo.LibraryStatus status = lib.testIntegrity(libDir);
            if (status == VersionInfo.LibraryStatus.PASSED) {
                return DownloadStatus.SUCCESS;
            }
            return DownloadStatus.DOWNLOAD_FAILED;
        }
        catch (MalformedURLException e) {
            return DownloadStatus.MALFORMED_URL;
        }
        catch (FileNotFoundException e) {
            return DownloadStatus.FILE_NOT_FOUND;
        }
        catch (IOException e) {
            return DownloadStatus.DOWNLOAD_FAILED;
        }
    }

    public static String prettyPrintSize(int size) {
        float fSize = size;
        String unit = "B";
        if (size >= 0x100000) {
            fSize /= 1048576.0f;
            unit = "MiB";
        } else if (size >= 1024) {
            fSize /= 1024.0f;
            unit = "KiB";
        }
        if (fSize >= 10.0f) {
            return String.format("%d %s", (int)fSize, unit);
        }
        return String.format("%.1f %s", Float.valueOf(fSize), unit);
    }

    static interface ShowLauncher {
        public boolean showLauncher();
    }
}

