/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.launcher;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import se.llbit.chunky.launcher.ChunkyLauncher;
import se.llbit.chunky.launcher.DownloadStatus;
import se.llbit.chunky.launcher.LauncherSettings;
import se.llbit.chunky.launcher.VersionInfo;
import se.llbit.chunky.resources.SettingsDirectory;

public class ConsoleUpdater {
    public static void update(VersionInfo version, LauncherSettings settings) {
        File versionsDir;
        File chunkyDir = SettingsDirectory.getSettingsDirectory();
        File libDir = new File(chunkyDir, "lib");
        if (!libDir.isDirectory()) {
            libDir.mkdirs();
        }
        if (!(versionsDir = new File(chunkyDir, "versions")).isDirectory()) {
            versionsDir.mkdirs();
        }
        for (VersionInfo.Library lib : version.libraries) {
            VersionInfo.LibraryStatus libStatus = lib.testIntegrity(libDir);
            if (libStatus == VersionInfo.LibraryStatus.PASSED || libStatus == VersionInfo.LibraryStatus.INCOMPLETE_INFO) continue;
            String libSize = ChunkyLauncher.prettyPrintSize(lib.size);
            System.out.format("Downloading %s [%s]...", lib, libSize);
            if (ConsoleUpdater.downloadLibrary(libDir, lib, System.out, settings)) {
                System.out.println("done!");
                continue;
            }
            return;
        }
        try {
            File versionFile = new File(versionsDir, version.name + ".json");
            version.writeTo(versionFile);
        }
        catch (IOException e) {
            System.err.println("Failed to update version info. Please try again later.");
        }
    }

    private static boolean downloadLibrary(File libDir, VersionInfo.Library lib, PrintStream err, LauncherSettings settings) {
        if (!lib.url.isEmpty()) {
            DownloadStatus result = ChunkyLauncher.tryDownload(libDir, lib, lib.url);
            switch (result) {
                case MALFORMED_URL: {
                    err.println("Malformed URL: " + lib.url);
                    break;
                }
                case FILE_NOT_FOUND: {
                    err.println("File not found: " + lib.url);
                    break;
                }
                case DOWNLOAD_FAILED: {
                    err.println("Download failed: " + lib.url);
                    break;
                }
                case SUCCESS: {
                    return true;
                }
            }
        }
        String defaultUrl = settings.getResourceUrl("lib/" + lib.name);
        if (!lib.url.isEmpty()) {
            err.print("  retrying with URL=" + defaultUrl + "...");
        }
        DownloadStatus result = ChunkyLauncher.tryDownload(libDir, lib, defaultUrl);
        switch (result) {
            case MALFORMED_URL: {
                err.println("Malformed URL: " + defaultUrl);
                return false;
            }
            case FILE_NOT_FOUND: {
                err.println("File not found: " + defaultUrl);
                return false;
            }
            case DOWNLOAD_FAILED: {
                err.println("Download failed: " + defaultUrl);
                return false;
            }
            case SUCCESS: {
                return true;
            }
        }
        return false;
    }
}

