/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.launcher;

import java.io.File;

public class JreUtil {
    public static boolean isJreDir(File jre) {
        File executable = JreUtil.javaExecutable(jre);
        return executable != null && executable.canExecute();
    }

    public static File javaExecutable(File jre) {
        if (!jre.isDirectory()) {
            return null;
        }
        File bin = new File(jre, "bin");
        if (bin != null && bin.isDirectory()) {
            String os = System.getProperty("os.name").toLowerCase();
            String exeName = os.contains("win") ? "java.exe" : "java";
            return new File(bin, exeName);
        }
        return null;
    }

    public static String javaCommand(String javaDir) {
        File executable = JreUtil.javaExecutable(new File(javaDir));
        if (executable == null) {
            executable = JreUtil.javaExecutable(new File(System.getProperty("java.home")));
        }
        if (executable != null) {
            return executable.getAbsolutePath();
        }
        System.err.println("Can not run Chunky! Unable to locate Java runtime!");
        return "";
    }
}

