/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.launcher;

import java.io.File;
import se.llbit.chunky.JsonSettings;
import se.llbit.chunky.resources.SettingsDirectory;
import se.llbit.util.OSDetector;

public class LauncherSettings {
    private static final int DEFAULT_MEMORY_LIMIT = 1024;
    public static final String LAUNCHER_SETTINGS_FILE = "chunky-launcher.json";
    public static final String DEFAULT_UPDATE_SITE = "http://chunkyupdate2.llbit.se/";
    public String javaDir = "";
    public int memoryLimit = 1024;
    public String updateSite = "http://chunkyupdate2.llbit.se/";
    public boolean debugConsole = false;
    public boolean forceGuiConsole = false;
    public boolean verboseLogging = false;
    public boolean verboseLauncher = false;
    public String javaOptions = "";
    public String chunkyOptions = "";
    public String version = "\u6700\u65b0\u7248\u672c";
    public boolean closeConsoleOnExit = true;
    private final JsonSettings settings = new JsonSettings();
    public boolean headless = false;
    public boolean showLauncher = true;
    public boolean showAdvancedSettings = false;
    public boolean downloadSnapshots = false;

    public LauncherSettings() {
        this.javaOptions = this.defaultJavaOptions();
    }

    public void load() {
        File directory = SettingsDirectory.getSettingsDirectory();
        if (directory != null) {
            this.settings.load(new File(directory, LAUNCHER_SETTINGS_FILE));
        }
        this.updateSite = this.settings.getString("updateSite", DEFAULT_UPDATE_SITE);
        this.javaDir = this.settings.getString("javaDir", "");
        if (this.javaDir.isEmpty()) {
            this.javaDir = this.settings.getString("javaExecutable", "");
        }
        if (this.javaDir.isEmpty()) {
            this.javaDir = System.getProperty("java.home");
        }
        this.memoryLimit = this.settings.getInt("memoryLimit", 1024);
        this.debugConsole = this.settings.getBool("showConsole", false);
        this.verboseLogging = this.settings.getBool("verboseLogging", false);
        this.verboseLauncher = this.settings.getBool("verboseLauncher", false);
        this.closeConsoleOnExit = this.settings.getBool("closeConsoleOnExit", true);
        this.javaOptions = this.settings.getString("javaOptions", this.defaultJavaOptions());
        this.chunkyOptions = this.settings.getString("chunkyOptions", "");
        this.version = this.settings.getString("version", "latest");
        this.showLauncher = this.settings.getBool("showLauncher", true);
        this.showAdvancedSettings = this.settings.getBool("showAdvancedSettings", false);
        this.downloadSnapshots = this.settings.getBool("downloadSnapshots", false);
    }

    private String defaultJavaOptions() {
        return OSDetector.getOS() == OSDetector.OS.WIN ? "-Dprism.order=sw" : "";
    }

    public void save() {
        this.settings.setString("updateSite", this.updateSite);
        this.settings.setString("javaDir", this.javaDir);
        this.settings.setInt("memoryLimit", this.memoryLimit);
        this.settings.setBool("showConsole", this.debugConsole);
        this.settings.setBool("verboseLogging", this.verboseLogging);
        this.settings.setBool("verboseLauncher", this.verboseLauncher);
        this.settings.setBool("closeConsoleOnExit", this.closeConsoleOnExit);
        this.settings.setString("javaOptions", this.javaOptions);
        this.settings.setString("chunkyOptions", this.chunkyOptions);
        this.settings.setString("version", this.version);
        this.settings.setBool("showLauncher", this.showLauncher);
        this.settings.setBool("showAdvancedSettings", this.showAdvancedSettings);
        this.settings.setBool("downloadSnapshots", this.downloadSnapshots);
        File directory = SettingsDirectory.getSettingsDirectory();
        this.settings.save(directory, new File(directory, LAUNCHER_SETTINGS_FILE));
    }

    public String getResourceUrl(String path) {
        String updateSite = this.updateSite;
        if (!updateSite.endsWith("/")) {
            updateSite = updateSite + "/";
        }
        return updateSite + path;
    }
}

