/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import se.llbit.chunky.launcher.ChunkyDeployer;
import se.llbit.chunky.launcher.LauncherSettings;
import se.llbit.chunky.launcher.UpdateListener;
import se.llbit.chunky.launcher.VersionInfo;
import se.llbit.json.JsonParser;

public class UpdateChecker
extends Thread {
    private final LauncherSettings settings;
    private final UpdateListener listener;

    public UpdateChecker(LauncherSettings settings, UpdateListener listener) {
        this.settings = settings;
        this.listener = listener;
    }

    @Override
    public void run() {
        try {
            if (!this.tryUpdate()) {
                this.listener.noUpdateAvailable();
            }
        }
        catch (Throwable e1) {
            System.err.println("Unhandled exception: " + e1.getMessage());
            this.listener.updateError("Can not update at this time.");
        }
    }

    private boolean tryUpdate() {
        LinkedList<VersionInfo> candidates = new LinkedList<VersionInfo>();
        this.getVersion(candidates, this.settings.getResourceUrl("latest.json"));
        if (this.settings.downloadSnapshots) {
            this.getVersion(candidates, this.settings.getResourceUrl("snapshot.json"));
        }
        Iterator<Object> iter = candidates.iterator();
        while (iter.hasNext()) {
            VersionInfo version = (VersionInfo)iter.next();
            if (version.isValid()) continue;
            System.err.println("Corrupted version info");
            this.listener.updateError("Downloaded corrupted version info: " + version);
            iter.remove();
        }
        if (candidates.isEmpty()) {
            return false;
        }
        VersionInfo latest = (VersionInfo)candidates.get(0);
        for (VersionInfo candidate : candidates) {
            if (candidate.compareTo(latest) >= 0) continue;
            latest = candidate;
        }
        List<VersionInfo> versions = ChunkyDeployer.availableVersions();
        for (VersionInfo available : versions) {
            if (available.compareTo(latest) > 0 || !ChunkyDeployer.checkVersionIntegrity(available.name)) continue;
            return false;
        }
        this.listener.updateAvailable(latest);
        return true;
    }

    private void getVersion(List<VersionInfo> candidates, String url) {
        try {
            URL latestJson = new URL(url);
            InputStream in = latestJson.openStream();
            JsonParser parser = new JsonParser(in);
            VersionInfo version = new VersionInfo(parser.parse().object());
            in.close();
            candidates.add(version);
        }
        catch (MalformedURLException e1) {
            System.err.println("Malformed version info URL.");
            this.listener.updateError("Malformed version info/update site URL: " + url);
        }
        catch (IOException e1) {
            System.err.println("Failed to fetch version info " + e1.getMessage());
            this.listener.updateError("Failed to fetch version info from URL: " + url);
        }
        catch (JsonParser.SyntaxError e1) {
            System.err.println("Version info JSON error: " + e1.getMessage());
            this.listener.updateError("Downloaded corrupt version info.");
        }
    }
}

