/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.launcher;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import se.llbit.json.JsonArray;
import se.llbit.json.JsonObject;
import se.llbit.json.JsonValue;
import se.llbit.json.PrettyPrinter;
import se.llbit.util.Util;

public class VersionInfo
implements Comparable<VersionInfo> {
    public static final VersionInfo LATEST = new VersionInfo("latest", new Date());
    public static final VersionInfo NONE = new VersionInfo("none", new Date());
    public final String name;
    public Collection<Library> libraries = new LinkedList<Library>();
    private final String timestamp;
    private final Date date;
    public String notes = "";

    public VersionInfo(JsonObject json) {
        this.name = json.get("name").stringValue("");
        this.timestamp = json.get("timestamp").stringValue("");
        this.date = Util.dateFromISO8601(this.timestamp);
        this.notes = json.get("notes").stringValue("");
        JsonArray libraryArray = json.get("libraries").array();
        for (JsonValue lib : libraryArray) {
            this.libraries.add(new Library(lib.object()));
        }
    }

    private VersionInfo(String name, Date date) {
        this.name = name;
        this.timestamp = Util.ISO8601FromDate(date);
        this.date = date;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof VersionInfo)) {
            return false;
        }
        VersionInfo other = (VersionInfo)obj;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return this.name;
    }

    @Override
    public int compareTo(VersionInfo o) {
        return o.date.compareTo(this.date);
    }

    public boolean isValid() {
        if (this.name.isEmpty()) {
            return false;
        }
        if (!Util.isValidISO8601(this.timestamp)) {
            return false;
        }
        for (Library lib : this.libraries) {
            if (!lib.name.isEmpty() && !lib.md5.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public void writeTo(File file) throws IOException {
        try (PrintStream out = new PrintStream(new FileOutputStream(file));){
            PrettyPrinter pp = new PrettyPrinter("  ", out);
            pp.print(this.json());
        }
    }

    private JsonObject json() {
        JsonObject obj = new JsonObject();
        obj.add("name", this.name);
        obj.add("timestamp", this.timestamp);
        obj.add("notes", this.notes);
        JsonArray libraryArray = new JsonArray();
        for (Library lib : this.libraries) {
            libraryArray.add(lib.json());
        }
        obj.add("libraries", libraryArray);
        return obj;
    }

    public String date() {
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy-MM-dd");
        return fmt.format(this.date);
    }

    public static class Library {
        public final String name;
        public final String md5;
        public final String url;
        public final int size;

        public Library(String name, String md5, int size) {
            this.name = name;
            this.md5 = md5;
            this.url = "";
            this.size = size;
        }

        public Library(JsonObject obj) {
            this.name = obj.get("name").stringValue("");
            this.md5 = obj.get("md5").stringValue("");
            this.url = obj.get("url").stringValue("");
            this.size = obj.get("size").intValue(1);
        }

        public File getFile(File libDir) {
            return new File(libDir, this.name);
        }

        public LibraryStatus testIntegrity(File libDir) {
            if (this.name.isEmpty() || this.md5.isEmpty()) {
                return LibraryStatus.INCOMPLETE_INFO;
            }
            File library = new File(libDir, this.name);
            if (!library.isFile()) {
                return LibraryStatus.MISSING;
            }
            String libMD5 = Util.md5sum(library);
            if (!libMD5.equalsIgnoreCase(this.md5)) {
                return LibraryStatus.MD5_MISMATCH;
            }
            return LibraryStatus.PASSED;
        }

        public JsonObject json() {
            JsonObject obj = new JsonObject();
            obj.add("name", this.name);
            obj.add("md5", this.md5);
            obj.add("url", this.url);
            obj.add("size", this.size);
            return obj;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum LibraryStatus {
        PASSED("Installed"),
        MD5_MISMATCH("To be downloaded (checksum mismatch)"),
        INCOMPLETE_INFO("Incomplete library information"),
        MISSING("To be downloaded (file missing)"),
        MALFORMED_URL("Download failed (malformed URL)"),
        FILE_NOT_FOUND("Download failed (file not found)"),
        DOWNLOAD_FAILED("Download failed"),
        DOWNLOADED_OK("Downloaded OK");

        public final String dlStatus;

        private LibraryStatus(String status) {
            this.dlStatus = status;
        }

        public String downloadStatus() {
            return this.dlStatus;
        }
    }
}

