/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.launcher.ui;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.stage.DirectoryChooser;
import javafx.stage.PopupWindow;
import javafx.stage.WindowEvent;
import se.llbit.chunky.PersistentSettings;
import se.llbit.chunky.launcher.ChunkyDeployer;
import se.llbit.chunky.launcher.ConsoleLogger;
import se.llbit.chunky.launcher.Dialogs;
import se.llbit.chunky.launcher.JreUtil;
import se.llbit.chunky.launcher.LaunchMode;
import se.llbit.chunky.launcher.LauncherSettings;
import se.llbit.chunky.launcher.UpdateChecker;
import se.llbit.chunky.launcher.UpdateListener;
import se.llbit.chunky.launcher.VersionInfo;
import se.llbit.chunky.launcher.ui.DebugConsole;
import se.llbit.chunky.launcher.ui.LaunchErrorDialog;
import se.llbit.chunky.launcher.ui.PluginManager;
import se.llbit.chunky.launcher.ui.UpdateDialog;
import se.llbit.chunky.resources.MinecraftFinder;
import se.llbit.chunky.resources.SettingsDirectory;
import se.llbit.chunky.ui.IntegerAdjuster;

public final class ChunkyLauncherController
implements Initializable,
UpdateListener {
    final LauncherSettings settings;
    @FXML
    protected ComboBox<VersionInfo> version;
    @FXML
    protected Button checkForUpdate;
    @FXML
    protected ProgressIndicator busyIndicator;
    @FXML
    protected TextField minecraftDirectory;
    @FXML
    protected Button browseMinecraft;
    @FXML
    protected IntegerAdjuster memoryLimit;
    @FXML
    protected TextField updateSite;
    @FXML
    protected Button resetUpdateSite;
    @FXML
    protected TextField javaRuntime;
    @FXML
    protected Button browseJava;
    @FXML
    protected TextField javaOptions;
    @FXML
    protected TextField chunkyOptions;
    @FXML
    protected CheckBox enableDebugConsole;
    @FXML
    protected CheckBox verboseLogging;
    @FXML
    protected CheckBox closeConsoleOnExit;
    @FXML
    protected CheckBox downloadSnapshots;
    @FXML
    protected TextField settingsDirectory;
    @FXML
    protected Button openSettingsDirectory;
    @FXML
    protected CheckBox alwaysShowLauncher;
    @FXML
    protected Button launchButton;
    @FXML
    protected Button cancelButton;
    @FXML
    protected Label launcherVersion;
    @FXML
    protected TitledPane advancedSettings;
    @FXML
    protected Button pluginsButton;

    public ChunkyLauncherController(LauncherSettings settings) {
        this.settings = settings;
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.busyIndicator.setTooltip(new Tooltip("\u6b63\u5728\u68c0\u67e5Chunky\u66f4\u65b0..."));
        this.cancelButton.setTooltip(new Tooltip("\u5173\u95edChunky\u542f\u52a8\u5668\u3002"));
        this.cancelButton.setOnAction(event -> this.cancelButton.getScene().getWindow().hide());
        this.pluginsButton.setTooltip(new Tooltip("\u81ea\u5b9a\u4e49\u63d2\u4ef6\u3002"));
        this.pluginsButton.setOnAction(event -> {
            try {
                PluginManager pluginManager = new PluginManager();
                pluginManager.show();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.launchButton.setTooltip(new Tooltip("\u4f7f\u7528\u5f53\u524d\u8bbe\u7f6e\u542f\u52a8Chunky\u3002"));
        this.launchButton.setOnAction(event -> this.launchChunky());
        this.launcherVersion.setText("v1.11.2");
        this.advancedSettings.setExpanded(this.settings.showAdvancedSettings);
        this.advancedSettings.expandedProperty().addListener(observable -> Platform.runLater(() -> this.advancedSettings.getScene().getWindow().sizeToScene()));
        this.memoryLimit.setTooltip("Maximum Java heap space in megabytes (MiB).\nLimited by the available memory in your computer.");
        this.memoryLimit.setRange(512.0, 16384.0);
        this.memoryLimit.makeLogarithmic();
        this.memoryLimit.set(this.settings.memoryLimit);
        this.memoryLimit.onValueChange(value -> {
            this.settings.memoryLimit = value;
        });
        this.alwaysShowLauncher.setSelected(this.settings.showLauncher);
        this.alwaysShowLauncher.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.settings.showLauncher = newValue;
        });
        this.minecraftDirectory.setText(MinecraftFinder.getMinecraftDirectory().getAbsolutePath());
        this.minecraftDirectory.setTooltip(new Tooltip("The Minecraft directory is used to find Minecraft saves and the default texture pack."));
        this.browseMinecraft.setTooltip(new Tooltip("\u9009\u62e9Minecraft\u76ee\u5f55\u3002"));
        this.browseMinecraft.setOnAction(event -> {
            File directory;
            DirectoryChooser chooser = new DirectoryChooser();
            chooser.setTitle("\u9009\u62e9Minecraft\u76ee\u5f55");
            File initialDirectory = MinecraftFinder.getMinecraftDirectory();
            if (initialDirectory != null && initialDirectory.isDirectory()) {
                chooser.setInitialDirectory(initialDirectory);
            }
            if ((directory = chooser.showDialog(this.browseMinecraft.getScene().getWindow())) != null) {
                if (MinecraftFinder.getMinecraftJar(directory, false) != null) {
                    String path = directory.getAbsolutePath();
                    this.minecraftDirectory.setText(path);
                    PersistentSettings.setMinecraftDirectory(path);
                } else {
                    this.launcherWarning("Not a Minecraft Directory", "Could not find a valid Minecraft installation in the selected directory.");
                }
            }
        });
        this.updateSite.setText(this.settings.updateSite);
        this.updateSite.setTooltip(new Tooltip("\u66f4\u65b0Chunky\u7248\u672c\u7684\u7f51\u7ad9URL\u3002"));
        this.updateSite.textProperty().addListener((observable, oldValue, newValue) -> {
            this.settings.updateSite = newValue;
            this.settings.save();
        });
        this.resetUpdateSite.setOnAction(event -> this.updateSite.setText("http://chunkyupdate2.llbit.se/"));
        this.resetUpdateSite.setTooltip(new Tooltip("\u91cd\u7f6e\u4e3a\u9ed8\u8ba4\u7684Chunky\u66f4\u65b0\u7ad9\u70b9\u3002"));
        this.javaRuntime.setText(this.getConfiguredJre());
        this.browseJava.setTooltip(new Tooltip("\u9009\u62e9Java\u73af\u5883\u76ee\u5f55\u3002"));
        this.browseJava.setOnAction(event -> {
            File directory;
            DirectoryChooser chooser = new DirectoryChooser();
            chooser.setTitle("Select Java Installation");
            File jreDir = new File(this.javaRuntime.getText());
            if (jreDir.isDirectory()) {
                chooser.setInitialDirectory(jreDir);
            }
            if ((directory = chooser.showDialog(this.browseJava.getScene().getWindow())) != null) {
                File jreSubDir = new File(directory, "jre");
                if (JreUtil.isJreDir(directory)) {
                    this.javaRuntime.setText(directory.getAbsolutePath());
                } else if (JreUtil.isJreDir(jreSubDir)) {
                    this.javaRuntime.setText(jreSubDir.getAbsolutePath());
                } else {
                    this.launcherWarning("Not a Java Runtime Installation", "Could not find a valid Java installation in the selected directory.");
                }
            }
        });
        this.javaOptions.setTooltip(new Tooltip("\u4f20\u9012\u7ed9Java\u7684\u9644\u52a0\u547d\u4ee4\u884c\u9009\u9879\u3002"));
        this.javaOptions.setText(this.settings.javaOptions);
        this.chunkyOptions.setTooltip(new Tooltip("\u4f20\u9012\u7ed9Chunky\u7684\u5176\u4ed6\u9009\u9879\u3002"));
        this.chunkyOptions.setText(this.settings.chunkyOptions);
        this.enableDebugConsole.setTooltip(new Tooltip("\u542f\u52a8Chunky\u65f6\u6253\u5f00\u8c03\u8bd5\u63a7\u5236\u53f0\u3002"));
        this.enableDebugConsole.setSelected(this.settings.debugConsole);
        this.verboseLogging.setTooltip(new Tooltip("\u542f\u7528\u8be6\u7ec6\u65e5\u5fd7\u8f93\u51fa\u3002"));
        this.verboseLogging.setSelected(this.settings.verboseLogging);
        this.closeConsoleOnExit.setTooltip(new Tooltip("\u5f53Chunky\u9000\u51fa\u65f6\u5173\u95ed\u8c03\u8bd5\u63a7\u5236\u53f0\u3002"));
        this.closeConsoleOnExit.setSelected(this.settings.closeConsoleOnExit);
        this.downloadSnapshots.setSelected(this.settings.downloadSnapshots);
        this.downloadSnapshots.selectedProperty().addListener((observable, oldValue, newValue) -> {
            this.settings.downloadSnapshots = newValue;
            this.settings.save();
        });
        this.openSettingsDirectory.setOnAction(event -> new Thread(() -> {
            try {
                if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().open(SettingsDirectory.getSettingsDirectory());
                } else {
                    Platform.runLater(() -> this.launcherWarning("Failed to open Settings Directory", "Can not open system file browser."));
                }
            }
            catch (IOException e1) {
                Platform.runLater(() -> this.launcherWarning("Failed to open Settings Directory", "Failed to open system file browser. Reason: " + e1.getMessage()));
            }
        }).start());
        this.checkForUpdate.setOnAction(event -> {
            if (this.isBusy()) {
                this.setBusy(true);
                UpdateChecker updateThread = new UpdateChecker(this.settings, this);
                updateThread.start();
            }
        });
    }

    protected void onShowing(WindowEvent event) {
        File settingsDir = SettingsDirectory.getSettingsDirectory();
        if (settingsDir != null) {
            this.settingsDirectory.setText(settingsDir.getAbsolutePath());
        }
        this.updateVersionList();
    }

    private String getConfiguredJre() {
        String configuredJre = this.settings.javaDir;
        if (!configuredJre.isEmpty() && JreUtil.isJreDir(new File(configuredJre))) {
            return configuredJre;
        }
        return System.getProperty("java.home");
    }

    private void launcherWarning(String title, String content) {
        Dialogs.warning(title, content);
    }

    public void launcherError(String title, String message) {
        Dialogs.error(title, message);
    }

    private void launchFailure(String message) {
        LaunchErrorDialog dialog = new LaunchErrorDialog(message);
        dialog.show();
        dialog.toFront();
    }

    void updateVersionList() {
        this.version.getItems().setAll((Object[])new VersionInfo[]{VersionInfo.LATEST});
        this.version.getItems().addAll(ChunkyDeployer.availableVersions());
        for (VersionInfo versionInfo : this.version.getItems()) {
            if (!versionInfo.name.equals(this.settings.version)) continue;
            this.version.getSelectionModel().select((Object)versionInfo);
            break;
        }
    }

    @Override
    public void updateError(String message) {
        Platform.runLater(() -> {
            this.launcherError("\u4e0b\u8f7d\u66f4\u65b0\u5931\u8d25", message);
            this.setBusy(false);
        });
    }

    @Override
    public void updateAvailable(VersionInfo latest) {
        Platform.runLater(() -> {
            try {
                UpdateDialog updateDialog = new UpdateDialog(this, latest);
                updateDialog.show();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        });
    }

    @Override
    public void noUpdateAvailable() {
        Platform.runLater(() -> {
            this.setBusy(false);
            Tooltip tooltip = new Tooltip("\u627e\u4e0d\u5230\u66f4\u65b0\u3002\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
            Point2D screen = this.checkForUpdate.localToScreen(0.0, 0.0);
            tooltip.setAnchorLocation(PopupWindow.AnchorLocation.CONTENT_TOP_RIGHT);
            tooltip.setAutoHide(true);
            tooltip.show((Node)this.checkForUpdate, screen.getX() + this.checkForUpdate.getWidth(), screen.getY() + this.checkForUpdate.getHeight());
        });
    }

    public void setBusy(boolean busy) {
        this.busyIndicator.setVisible(busy);
        this.checkForUpdate.setDisable(busy);
    }

    public boolean isBusy() {
        return !this.busyIndicator.isVisible();
    }

    public void selectLatestVersion() {
        this.version.getSelectionModel().select((Object)VersionInfo.LATEST);
    }

    public void launchChunky() {
        this.settings.javaDir = this.javaRuntime.getText();
        this.settings.debugConsole = this.enableDebugConsole.isSelected();
        this.settings.verboseLogging = this.verboseLogging.isSelected();
        this.settings.closeConsoleOnExit = this.closeConsoleOnExit.isSelected();
        this.settings.javaOptions = this.javaOptions.getText();
        this.settings.chunkyOptions = this.chunkyOptions.getText();
        this.settings.version = ((VersionInfo)this.version.getSelectionModel().getSelectedItem()).name;
        this.settings.showLauncher = this.alwaysShowLauncher.isSelected();
        this.settings.showAdvancedSettings = this.advancedSettings.isExpanded();
        VersionInfo version = ChunkyDeployer.resolveVersion(this.settings.version);
        if (!ChunkyDeployer.canLaunch(version, this, true)) {
            return;
        }
        ChunkyDeployer.LoggerBuilder loggerBuilder = () -> {
            if (this.settings.forceGuiConsole || !this.settings.headless && this.settings.debugConsole) {
                DebugConsole console = new DebugConsole(this.settings.closeConsoleOnExit);
                console.show();
                return console;
            }
            return new ConsoleLogger();
        };
        PersistentSettings.setMinecraftDirectory(this.minecraftDirectory.getText());
        if (ChunkyDeployer.launchChunky(this.settings, version, LaunchMode.GUI, this::launchFailure, loggerBuilder) == 0) {
            this.settings.save();
            this.cancelButton.getScene().getWindow().hide();
        }
    }
}

