/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.launcher.ui;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import se.llbit.chunky.launcher.LauncherSettings;
import se.llbit.chunky.launcher.ui.ChunkyLauncherController;

public class ChunkyLauncherFx
extends Application {
    private static LauncherSettings settings;
    private static AtomicBoolean first;
    private static CountDownLatch latch;
    private static Consumer<Stage> callback;
    private static Stage stage;

    public void start(Stage stage) throws Exception {
        FXMLLoader loader = new FXMLLoader(((Object)((Object)this)).getClass().getResource("ChunkyLauncher.fxml"));
        ChunkyLauncherController controller = new ChunkyLauncherController(settings);
        loader.setController((Object)controller);
        Parent root = (Parent)loader.load();
        stage.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("chunky-cfg.png")));
        stage.setTitle("Chunky\u542f\u52a8\u5668");
        stage.setScene(new Scene(root));
        stage.setOnShowing(controller::onShowing);
        ChunkyLauncherFx.stage = stage;
        latch.countDown();
        callback.accept(stage);
    }

    public static void withLauncher(LauncherSettings settings, Consumer<Stage> callback) {
        if (first.compareAndSet(true, false)) {
            new Thread(() -> {
                ChunkyLauncherFx.settings = settings;
                ChunkyLauncherFx.callback = callback;
                ChunkyLauncherFx.launch((String[])new String[0]);
            }).start();
        } else {
            try {
                latch.await();
                Platform.runLater(() -> callback.accept(stage));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    static {
        first = new AtomicBoolean(true);
        latch = new CountDownLatch(1);
    }
}

