/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.launcher.ui;

import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import se.llbit.chunky.launcher.Logger;

public class DebugConsole
extends Stage
implements Logger {
    private final TextArea statusText;
    private final boolean closeConsoleOnExit;

    public DebugConsole(boolean closeConsoleOnExit) {
        this.setTitle("\u8c03\u8bd5\u63a7\u5236\u53f0");
        this.closeConsoleOnExit = closeConsoleOnExit;
        this.statusText = new TextArea();
        this.statusText.setPrefWidth(600.0);
        this.statusText.setPrefHeight(400.0);
        this.statusText.setEditable(false);
        Button closeBtn = new Button("\u5173\u95ed");
        closeBtn.setDefaultButton(true);
        closeBtn.setCancelButton(true);
        closeBtn.setTooltip(new Tooltip("\u5173\u95ed\u8c03\u8bd5\u63a7\u5236\u53f0"));
        closeBtn.setOnAction(event -> this.hide());
        this.getIcons().add((Object)new Image(this.getClass().getResourceAsStream("chunky-cfg.png")));
        VBox buttonBar = new VBox();
        buttonBar.setPadding(new Insets(10.0));
        buttonBar.setAlignment(Pos.TOP_RIGHT);
        buttonBar.getChildren().add((Object)closeBtn);
        BorderPane content = new BorderPane();
        content.setCenter((Node)this.statusText);
        content.setBottom((Node)buttonBar);
        this.setScene(new Scene((Parent)content));
    }

    public void appendStatusText(String text) {
        Platform.runLater(() -> this.statusText.appendText(text));
    }

    @Override
    public void processExited(int exitValue) {
        if (exitValue == 0) {
            this.appendLine("Chunky\u6b63\u5e38\u9000\u51fa");
            if (this.closeConsoleOnExit) {
                Platform.runLater(() -> this.hide());
            }
        } else {
            this.appendLine("Chunky\u5f02\u5e38\u9000\u51fa\uff0c\u503c\uff1a" + exitValue);
        }
    }

    @Override
    public void appendStdout(byte[] buffer, int size) {
        this.appendStatusText(new String(buffer, 0, size));
    }

    @Override
    public void appendStderr(byte[] buffer, int size) {
        this.appendStatusText(new String(buffer, 0, size));
    }

    @Override
    public void appendLine(String line) {
        this.appendStatusText(line + "\n");
    }

    @Override
    public void appendErrorLine(String line) {
        this.appendStatusText(line + "\n");
    }
}

