/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.launcher.ui;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import se.llbit.chunky.PersistentSettings;
import se.llbit.chunky.launcher.Dialogs;
import se.llbit.chunky.resources.SettingsDirectory;

public class FirstTimeSetupDialog
extends Stage {
    public FirstTimeSetupDialog(Runnable onAccept) {
        this.setTitle("Chunky First-Time Setup");
        Label description = new Label("It looks like this is your first time starting Chunky!\n(or the previous settings could not be found)");
        Label description2 = new Label("Please select which directory to store Chunky configuration in:");
        ToggleGroup group = new ToggleGroup();
        RadioButton homeDirectoryBtn = new RadioButton("Home Directory (Recommended):\n" + SettingsDirectory.getHomeDirectory());
        homeDirectoryBtn.setToggleGroup(group);
        RadioButton programDirectoryBtn = new RadioButton("Program Directory (for portable/thumb drive installations):\n" + SettingsDirectory.getProgramDirectory());
        programDirectoryBtn.setToggleGroup(group);
        RadioButton workingDirectoryBtn = new RadioButton("Working Directory:\n" + SettingsDirectory.getWorkingDirectory());
        workingDirectoryBtn.setToggleGroup(group);
        homeDirectoryBtn.setSelected(true);
        this.getIcons().add((Object)new Image(((Object)((Object)this)).getClass().getResourceAsStream("chunky-cfg.png")));
        Button okBtn = new Button("Use Selected Directory");
        okBtn.setDefaultButton(true);
        okBtn.setOnAction(event -> {
            File settingsDir = homeDirectoryBtn.isSelected() ? SettingsDirectory.getHomeDirectory() : (programDirectoryBtn.isSelected() ? SettingsDirectory.getProgramDirectory() : SettingsDirectory.getWorkingDirectory());
            boolean initialized = false;
            if (settingsDir != null) {
                try {
                    if (!settingsDir.isDirectory()) {
                        settingsDir.mkdirs();
                    }
                    File settingsFile = new File(settingsDir, "chunky.json");
                    try (PrintStream out = new PrintStream(new FileOutputStream(settingsFile));){
                        out.println("{}");
                    }
                    File launcherSettings = new File(settingsDir, "chunky-launcher.json");
                    try (PrintStream out = new PrintStream(new FileOutputStream(launcherSettings));){
                        out.println("{}");
                    }
                    initialized = settingsFile.isFile() && launcherSettings.isFile();
                }
                catch (IOException e1) {
                    System.err.println(e1.getMessage());
                }
                PersistentSettings.changeSettingsDirectory(settingsDir);
            }
            if (!initialized) {
                Dialogs.error("Failed to Initialize", "Failed to initialize Chunky configuration directory! You may need administrative permissions on the computer to do this.");
            } else {
                onAccept.run();
                this.hide();
            }
        });
        Button cancelBtn = new Button("Cancel");
        cancelBtn.setCancelButton(true);
        cancelBtn.setOnAction(e -> this.hide());
        HBox buttons = new HBox();
        buttons.setSpacing(10.0);
        buttons.setAlignment(Pos.CENTER_RIGHT);
        buttons.getChildren().setAll((Object[])new Node[]{okBtn, cancelBtn});
        VBox vBox = new VBox();
        vBox.setPadding(new Insets(10.0));
        vBox.setSpacing(10.0);
        vBox.getChildren().setAll((Object[])new Node[]{description, description2, homeDirectoryBtn, programDirectoryBtn, workingDirectoryBtn, buttons});
        this.setScene(new Scene((Parent)vBox));
    }
}

