/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.launcher.ui;

import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import se.llbit.chunky.PersistentSettings;
import se.llbit.chunky.resources.SettingsDirectory;
import se.llbit.json.Json;
import se.llbit.json.JsonArray;
import se.llbit.json.JsonObject;
import se.llbit.json.JsonParser;
import se.llbit.json.JsonValue;
import se.llbit.log.Log;

public class PluginManagerController
implements Initializable {
    @FXML
    protected Button saveButton;
    @FXML
    protected Button addButton;
    @FXML
    protected Button deleteButton;
    @FXML
    protected Button upButton;
    @FXML
    protected Button downButton;
    @FXML
    protected TableView<JsonObject> tableView;
    @FXML
    protected TableColumn<JsonObject, JsonObject> pluginColumn;
    @FXML
    protected TableColumn<JsonObject, Boolean> enabledColumn;
    @FXML
    protected Button openPluginDir;
    @FXML
    protected Label pluginName;
    @FXML
    protected Label pluginVersion;
    @FXML
    protected Label targetVersion;
    @FXML
    protected Text description;
    @FXML
    protected Label author;
    @FXML
    protected VBox pluginDetails;
    @FXML
    protected VBox errorDetails;
    @FXML
    protected TextArea errorMessage;
    private File pluginsDirectory = SettingsDirectory.getPluginsDirectory();

    public void initialize(URL location, ResourceBundle resources) {
        this.saveButton.setOnAction(e -> {
            JsonArray array = new JsonArray();
            this.tableView.getItems().forEach(plugin -> {
                if (plugin.get("enabled").asBoolean(false)) {
                    array.add(plugin.get("jar").stringValue(""));
                }
            });
            PersistentSettings.setPlugins(array);
            this.saveButton.getScene().getWindow().hide();
        });
        this.addButton.setOnAction(e -> {
            FileChooser fileChooser = new FileChooser();
            fileChooser.setTitle("\u9009\u62e9\u63d2\u4ef6\u5305");
            fileChooser.setSelectedExtensionFilter(new FileChooser.ExtensionFilter("Jar", new String[]{"*.jar"}));
            File jar = fileChooser.showOpenDialog(this.addButton.getScene().getWindow());
            if (jar != null) {
                boolean alreadyExists;
                File pluginsDir = SettingsDirectory.getPluginsDirectory();
                if (!pluginsDir.isDirectory()) {
                    pluginsDir.mkdirs();
                }
                if (alreadyExists = this.pluginExists(jar.getName())) {
                    Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
                    alert.setTitle("\u66ff\u6362\u63d2\u4ef6");
                    alert.setContentText(String.format("\u7528\u65b0\u6587\u4ef6%s\u66ff\u6362\u63d2\u4ef6%s\uff1f", jar.getName(), jar.getAbsolutePath()));
                    if (alert.showAndWait().get() != ButtonType.OK) {
                        return;
                    }
                }
                try {
                    Files.copy(jar.toPath(), pluginsDir.toPath().resolve(jar.getName()), StandardCopyOption.REPLACE_EXISTING);
                    if (alreadyExists) {
                        this.enablePlugin(jar.getName());
                        this.tableView.refresh();
                    } else {
                        this.addPlugin(jar.getName(), true);
                    }
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.openPluginDir.setOnAction(event -> new Thread(() -> {
            try {
                if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().open(SettingsDirectory.getPluginsDirectory());
                } else {
                    Log.warn("\u65e0\u6cd5\u6253\u5f00\u7cfb\u7edf\u6587\u4ef6\u6d4f\u89c8\u5668\u3002");
                }
            }
            catch (IOException e1) {
                Log.warn("\u6253\u5f00\u573a\u666f\u76ee\u5f55\u5931\u8d25\u3002", e1);
            }
        }).start());
        this.deleteButton.setTooltip(new Tooltip("\u4ece\u63d2\u4ef6\u76ee\u5f55\u4e2d\u5220\u9664\u63d2\u4ef6\u5305\u6587\u4ef6\u3002"));
        this.deleteButton.setOnAction(event -> {
            JsonObject plugin = (JsonObject)this.tableView.getSelectionModel().getSelectedItem();
            String jar = plugin.get("jar").asString("");
            if (!jar.isEmpty()) {
                Path jarPath = SettingsDirectory.getPluginsDirectory().toPath().resolve(jar);
                try {
                    Files.delete(jarPath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.tableView.getItems().remove((Object)plugin);
        });
        this.upButton.setTooltip(new Tooltip("Move the selected plugin earlier in the load order."));
        this.upButton.setOnAction(event -> {
            int selected = this.tableView.getSelectionModel().getSelectedIndex();
            if (selected > 0) {
                JsonObject item = (JsonObject)this.tableView.getItems().remove(selected);
                this.tableView.getItems().add(selected - 1, (Object)item);
                this.tableView.getSelectionModel().select(selected - 1);
            }
        });
        this.downButton.setTooltip(new Tooltip("Move the selected plugin later in the load order."));
        this.downButton.setOnAction(event -> {
            int selected = this.tableView.getSelectionModel().getSelectedIndex();
            if (selected >= 0 && selected + 1 < this.tableView.getItems().size()) {
                JsonObject item = (JsonObject)this.tableView.getItems().remove(selected);
                this.tableView.getItems().add(selected + 1, (Object)item);
                this.tableView.getSelectionModel().select(selected + 1);
            }
        });
        this.enabledColumn.setCellValueFactory(data -> {
            SimpleBooleanProperty property = new SimpleBooleanProperty(((JsonObject)data.getValue()).get("enabled").boolValue(true));
            property.addListener((observable, oldValue, enabled) -> {
                if (enabled.booleanValue()) {
                    this.enablePlugin((JsonObject)data.getValue());
                } else {
                    ((JsonObject)data.getValue()).set("enabled", Json.of(false));
                }
            });
            return property;
        });
        this.enabledColumn.setCellFactory(CheckBoxTableCell.forTableColumn(this.enabledColumn));
        this.pluginColumn.setCellValueFactory(data -> new ReadOnlyObjectWrapper(data.getValue()));
        this.pluginColumn.setCellFactory(column -> new TableCell<JsonObject, JsonObject>(){

            protected void updateItem(JsonObject item, boolean empty) {
                super.updateItem((Object)item, empty);
                if (empty) {
                    this.setText("");
                    this.getTableRow().setStyle("");
                } else {
                    this.setText(item.get("jar").asString(""));
                    if (item.get("error").asString("").isEmpty()) {
                        this.getTableRow().setStyle("");
                    } else {
                        this.getTableRow().setStyle("-fx-background-color:#ff7878");
                    }
                }
            }
        });
        this.tableView.setEditable(true);
        this.pluginColumn.setEditable(false);
        this.tableView.getSelectionModel().selectedItemProperty().addListener((observable, oldValue, plugin) -> {
            if (plugin != null) {
                String error = plugin.get("error").asString("");
                if (error.isEmpty()) {
                    this.errorDetails.setVisible(false);
                    this.pluginDetails.setVisible(true);
                    this.pluginName.setText(plugin.get("name").asString(""));
                    this.pluginVersion.setText(plugin.get("version").asString(""));
                    this.targetVersion.setText(plugin.get("targetVersion").asString(""));
                    this.author.setText(plugin.get("author").asString(""));
                    this.description.setText(plugin.get("description").asString(""));
                } else {
                    this.errorDetails.setVisible(true);
                    this.pluginDetails.setVisible(false);
                    this.errorMessage.setText(error);
                }
            }
        });
        LinkedHashSet<String> enabled = new LinkedHashSet<String>();
        JsonArray plugins = PersistentSettings.getPlugins();
        for (JsonValue plugin2 : ((JsonValue)plugins).array()) {
            String pluginJar = plugin2.asString("");
            if (pluginJar.isEmpty()) continue;
            enabled.add(pluginJar);
        }
        if (!this.pluginsDirectory.isDirectory()) {
            this.pluginsDirectory.mkdirs();
        }
        Log.info("\u4ece" + this.pluginsDirectory.getAbsolutePath() + "\u83b7\u53d6\u63d2\u4ef6");
        File[] pluginFiles = this.pluginsDirectory.listFiles(f -> f.getName().endsWith(".jar"));
        if (pluginFiles != null) {
            for (String jar : enabled) {
                this.addPlugin(jar, true);
            }
            for (File file : pluginFiles) {
                if (enabled.contains(file.getName())) continue;
                this.addPlugin(file.getName(), false);
            }
        }
    }

    private void enablePlugin(String jar) {
        for (JsonObject plugin : this.tableView.getItems()) {
            if (!plugin.get("jar").asString("").equals(jar)) continue;
            this.enablePlugin(plugin);
            return;
        }
    }

    private void enablePlugin(JsonObject plugin) {
        plugin.set("enabled", Json.of(true));
        int start = this.tableView.getItems().indexOf((Object)plugin);
        if (start > 0) {
            JsonObject item;
            int index;
            for (index = start - 1; index >= 0 && !(item = (JsonObject)this.tableView.getItems().get(index)).get("enabled").boolValue(false); --index) {
            }
            int selected = this.tableView.getSelectionModel().getSelectedIndex();
            this.tableView.getItems().remove(start);
            this.tableView.getItems().add(index + 1, (Object)plugin);
            if (selected == start) {
                this.tableView.getSelectionModel().select(index + 1);
            }
        }
    }

    private boolean pluginExists(String jar) {
        for (JsonObject plugin : this.tableView.getItems()) {
            if (!plugin.get("jar").asString("").equals(jar)) continue;
            return true;
        }
        return false;
    }

    private void addPlugin(String jar, boolean enabled) {
        JsonObject plugin;
        block41: {
            Path pluginPath = this.pluginsDirectory.toPath().resolve(jar);
            plugin = new JsonObject();
            try (FileSystem zipFs = FileSystems.newFileSystem(URI.create("jar:" + pluginPath.toUri()), Collections.emptyMap());){
                Path manifestPath = zipFs.getPath("/plugin.json", new String[0]);
                if (Files.exists(manifestPath, new LinkOption[0])) {
                    try (InputStream in = Files.newInputStream(manifestPath, new OpenOption[0]);
                         JsonParser parser = new JsonParser(in);){
                        JsonObject manifest = parser.parse().object();
                        plugin.add("name", manifest.get("name"));
                        plugin.add("version", manifest.get("version"));
                        plugin.add("author", manifest.get("author"));
                        plugin.add("targetVersion", manifest.get("targetVersion"));
                        plugin.add("description", manifest.get("description"));
                        break block41;
                    }
                    catch (JsonParser.SyntaxError syntaxError) {
                        syntaxError.printStackTrace();
                    }
                    break block41;
                }
                plugin.add("error", String.format("%s\u4e2d\u7f3a\u5c11\u63d2\u4ef6\u6e05\u5355\u6587\u4ef6\uff08plugin.json\uff09\u3002", jar));
            }
            catch (IOException e) {
                plugin.add("error", String.format("\u65e0\u6cd5\u8bfb\u53d6\u63d2\u4ef6%s\uff08%s\uff09\u3002", jar, e.getMessage()));
            }
        }
        plugin.add("jar", jar);
        plugin.add("enabled", enabled);
        this.tableView.getItems().add((Object)plugin);
    }
}

