/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.launcher.ui;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextArea;
import javafx.scene.control.TitledPane;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.text.Text;
import se.llbit.chunky.launcher.ChunkyLauncher;
import se.llbit.chunky.launcher.DownloadStatus;
import se.llbit.chunky.launcher.VersionInfo;
import se.llbit.chunky.launcher.ui.ChunkyLauncherController;
import se.llbit.chunky.resources.SettingsDirectory;
import se.llbit.util.Pair;

public final class UpdateDialogController
implements Initializable {
    private final VersionInfo versionInfo;
    private final File libDir;
    private final File versionsDir;
    private final ExecutorService threadPool;
    private final ChunkyLauncherController launcher;
    @FXML
    protected Text releaseInfo;
    @FXML
    protected TextArea releaseNotes;
    @FXML
    protected Button updateButton;
    @FXML
    protected Button cancelButton;
    @FXML
    protected TitledPane detailsPane;
    @FXML
    protected TableView<Pair<VersionInfo.Library, VersionInfo.LibraryStatus>> dependencies;
    @FXML
    protected TableColumn<Pair<VersionInfo.Library, VersionInfo.LibraryStatus>, String> libraryCol;
    @FXML
    protected TableColumn<Pair<VersionInfo.Library, VersionInfo.LibraryStatus>, VersionInfo.LibraryStatus> statusCol;
    @FXML
    protected TableColumn<Pair<VersionInfo.Library, VersionInfo.LibraryStatus>, String> sizeCol;
    @FXML
    protected ProgressIndicator busyIndicator;
    @FXML
    protected ProgressBar progress;
    @FXML
    protected Label updateComplete;

    public UpdateDialogController(ChunkyLauncherController launcher, VersionInfo versionInfo) {
        this.launcher = launcher;
        this.versionInfo = versionInfo;
        File chunkyDir = SettingsDirectory.getSettingsDirectory();
        this.libDir = new File(chunkyDir, "lib");
        if (!this.libDir.isDirectory()) {
            this.libDir.mkdirs();
        }
        this.versionsDir = new File(chunkyDir, "versions");
        if (!this.versionsDir.isDirectory()) {
            this.versionsDir.mkdirs();
        }
        this.threadPool = Executors.newFixedThreadPool(4, runnable -> {
            Thread thread = Executors.defaultThreadFactory().newThread(runnable);
            thread.setDaemon(true);
            return thread;
        });
    }

    public void initialize(URL location, ResourceBundle resources) {
        this.releaseInfo.setText(String.format("\u7248\u672c%s\uff0c\u53d1\u5e03\u4e8e%s", this.versionInfo.name, this.versionInfo.date()));
        if (this.versionInfo.notes.isEmpty()) {
            this.releaseNotes.setText("\u6ca1\u6709\u53ef\u7528\u7684\u66f4\u65b0\u8bf4\u660e\u3002");
        } else {
            this.releaseNotes.setText(this.versionInfo.notes);
        }
        this.updateButton.setOnAction(event -> this.downloadUpdate());
        this.cancelButton.setOnAction(event -> this.cancelButton.getScene().getWindow().hide());
        this.detailsPane.expandedProperty().addListener(observable -> Platform.runLater(() -> this.detailsPane.getScene().getWindow().sizeToScene()));
        this.dependencies.getItems().addAll((Collection)this.versionInfo.libraries.stream().map(lib -> new Pair<VersionInfo.Library, VersionInfo.LibraryStatus>((VersionInfo.Library)lib, lib.testIntegrity(this.libDir))).collect(Collectors.toList()));
        this.libraryCol.setCellValueFactory(data -> new ReadOnlyStringWrapper(((VersionInfo.Library)((Pair)data.getValue()).thing1).name));
        this.statusCol.setCellValueFactory(data -> new ReadOnlyObjectWrapper(((Pair)data.getValue()).thing2));
        this.sizeCol.setCellValueFactory(data -> new ReadOnlyStringWrapper(ChunkyLauncher.prettyPrintSize(((VersionInfo.Library)((Pair)data.getValue()).thing1).size)));
        this.statusCol.setCellFactory(param -> new TableCell<Pair<VersionInfo.Library, VersionInfo.LibraryStatus>, VersionInfo.LibraryStatus>(){

            protected void updateItem(VersionInfo.LibraryStatus status, boolean empty) {
                if (status != null) {
                    InputStream imageStream = null;
                    switch (status) {
                        case PASSED: 
                        case DOWNLOADED_OK: {
                            imageStream = ((Object)((Object)this)).getClass().getResourceAsStream("cached.png");
                            break;
                        }
                        case MD5_MISMATCH: 
                        case MISSING: {
                            imageStream = ((Object)((Object)this)).getClass().getResourceAsStream("refresh.png");
                            break;
                        }
                        case INCOMPLETE_INFO: 
                        case MALFORMED_URL: 
                        case FILE_NOT_FOUND: 
                        case DOWNLOAD_FAILED: {
                            imageStream = ((Object)((Object)this)).getClass().getResourceAsStream("failed.png");
                        }
                    }
                    if (imageStream != null) {
                        ImageView image = new ImageView(new Image(imageStream));
                        this.setGraphic((Node)image);
                    }
                    this.setText(status.downloadStatus());
                }
            }
        });
    }

    private void downloadUpdate() {
        this.updateButton.setDisable(true);
        this.busyIndicator.setVisible(true);
        this.progress.setProgress(0.0);
        this.progress.setStyle("");
        if (!this.libDir.isDirectory()) {
            this.updateFailed(String.format("\u6587\u4ef6\u76ee\u5f55\uff08%s\uff09\u4e0d\u5b58\u5728\u3002", this.libDir.getAbsolutePath()));
            return;
        }
        if (!this.versionsDir.isDirectory()) {
            this.updateFailed(String.format("\u7248\u672c\u76ee\u5f55\uff08%s\uff09\u4e0d\u5b58\u5728\u3002", this.libDir.getAbsolutePath()));
            return;
        }
        LinkedList<Future<DownloadStatus>> results = new LinkedList<Future<DownloadStatus>>();
        List toDownload = this.dependencies.getItems().stream().filter(item -> item.thing2 != VersionInfo.LibraryStatus.PASSED && item.thing2 != VersionInfo.LibraryStatus.INCOMPLETE_INFO).collect(Collectors.toList());
        double totalBytes = 0.0;
        for (Pair download : toDownload) {
            totalBytes += (double)((VersionInfo.Library)download.thing1).size;
        }
        double finalTotalBytes = totalBytes;
        toDownload.stream().forEach(item -> results.add(this.threadPool.submit(new DownloadJob((VersionInfo.Library)item.thing1, () -> this.progress.setProgress(this.progress.getProgress() + (double)((VersionInfo.Library)item.thing1).size / finalTotalBytes)))));
        new Downloader(this, this.versionInfo, results).start();
    }

    private void updateFailed(String message) {
        Platform.runLater(() -> {
            this.progress.setProgress(1.0);
            this.progress.setStyle("-fx-accent: red;");
            Tooltip tooltip = new Tooltip(message);
            Point2D screen = this.progress.localToScreen(0.0, 0.0);
            tooltip.setAutoHide(true);
            tooltip.show((Node)this.progress, screen.getX(), screen.getY() + this.progress.getHeight());
            this.updateButton.setDisable(false);
            this.busyIndicator.setVisible(false);
            System.err.println(message);
        });
    }

    private void downloadSucceeded() {
        Platform.runLater(() -> {
            this.progress.setProgress(1.0);
            this.progress.setStyle("-fx-accent: green;");
            this.updateComplete.setVisible(true);
            this.cancelButton.setText("\u5173\u95ed");
            this.updateButton.setDisable(false);
            this.updateButton.setText("\u542f\u52a8Chunky");
            this.updateButton.setOnAction(event -> {
                this.updateButton.getScene().getWindow().hide();
                this.launcher.launchChunky();
            });
            this.launcher.updateVersionList();
            this.launcher.selectLatestVersion();
            this.busyIndicator.setVisible(false);
        });
    }

    private void updateDependencyStatus(VersionInfo.Library lib, VersionInfo.LibraryStatus newStatus) {
        this.dependencies.getItems().setAll((Collection)this.dependencies.getItems().stream().map(item -> {
            if (item.thing1 != lib) {
                return item;
            }
            return new Pair(item.thing1, newStatus);
        }).collect(Collectors.toList()));
    }

    class DownloadJob
    implements Callable<DownloadStatus> {
        private final VersionInfo.Library lib;
        private final Runnable callback;

        public DownloadJob(VersionInfo.Library lib, Runnable callback) {
            this.lib = lib;
            this.callback = callback;
        }

        @Override
        public DownloadStatus call() {
            DownloadStatus result = null;
            if (!this.lib.url.isEmpty()) {
                result = ChunkyLauncher.tryDownload(UpdateDialogController.this.libDir, this.lib, this.lib.url);
                switch (result) {
                    case MALFORMED_URL: {
                        System.err.println("\u683c\u5f0f\u9519\u8bef\u7684URL\uff1a" + this.lib.url);
                        break;
                    }
                    case FILE_NOT_FOUND: {
                        System.err.println("\u627e\u4e0d\u5230\u6587\u4ef6\uff1a" + this.lib.url);
                        break;
                    }
                    case DOWNLOAD_FAILED: {
                        System.err.println("\u4e0b\u8f7d\u5931\u8d25\uff1a" + this.lib.url);
                        break;
                    }
                }
            }
            String defaultUrl = ((UpdateDialogController)UpdateDialogController.this).launcher.settings.updateSite + "lib/" + this.lib.name;
            if (result != DownloadStatus.SUCCESS) {
                result = ChunkyLauncher.tryDownload(UpdateDialogController.this.libDir, this.lib, defaultUrl);
            }
            switch (result) {
                case SUCCESS: {
                    UpdateDialogController.this.updateDependencyStatus(this.lib, VersionInfo.LibraryStatus.DOWNLOADED_OK);
                    break;
                }
                case MALFORMED_URL: {
                    UpdateDialogController.this.updateDependencyStatus(this.lib, VersionInfo.LibraryStatus.MALFORMED_URL);
                    System.err.println("\u683c\u5f0f\u9519\u8bef\u7684URL\uff1a" + defaultUrl);
                    break;
                }
                case FILE_NOT_FOUND: {
                    UpdateDialogController.this.updateDependencyStatus(this.lib, VersionInfo.LibraryStatus.FILE_NOT_FOUND);
                    System.err.println("\u627e\u4e0d\u5230\u6587\u4ef6\uff1a" + defaultUrl);
                    break;
                }
                case DOWNLOAD_FAILED: {
                    UpdateDialogController.this.updateDependencyStatus(this.lib, VersionInfo.LibraryStatus.DOWNLOAD_FAILED);
                    System.err.println("\u4e0b\u8f7d\u5931\u8d25\uff1a" + defaultUrl);
                }
            }
            this.callback.run();
            return result;
        }
    }

    static class Downloader
    extends Thread {
        private final Collection<Future<DownloadStatus>> results;
        private final UpdateDialogController controller;
        private final VersionInfo version;

        public Downloader(UpdateDialogController controller, VersionInfo version, Collection<Future<DownloadStatus>> resultFutures) {
            this.controller = controller;
            this.version = version;
            this.results = resultFutures;
        }

        @Override
        public void run() {
            boolean failed = false;
            for (Future<DownloadStatus> result : this.results) {
                try {
                    if (result.get() == DownloadStatus.SUCCESS) continue;
                    failed = true;
                }
                catch (InterruptedException | ExecutionException e) {
                    failed = true;
                }
            }
            if (failed) {
                this.controller.updateFailed("\u672a\u80fd\u4e0b\u8f7d\u67d0\u4e9b\u5fc5\u9700\u7684\u5e93\u3002\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
                return;
            }
            try {
                File versionFile = new File(this.controller.versionsDir, this.version.name + ".json");
                this.version.writeTo(versionFile);
                this.controller.downloadSucceeded();
            }
            catch (IOException e) {
                this.controller.updateFailed("\u66f4\u65b0\u7248\u672c\u4fe1\u606f\u5931\u8d25\u3002\u8bf7\u7a0d\u540e\u518d\u8bd5\u3002");
            }
        }
    }
}

