/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.resources;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import se.llbit.chunky.PersistentSettings;
import se.llbit.chunky.resources.SettingsDirectory;
import se.llbit.json.JsonObject;
import se.llbit.json.JsonParser;
import se.llbit.log.Log;
import se.llbit.util.OSDetector;
import se.llbit.util.Util;

public class MinecraftFinder {
    private static File minecraftJar = null;
    private static boolean foundJar = false;

    public static File getMinecraftDirectory() {
        File mcDir = new File(PersistentSettings.getMinecraftDirectory());
        if (MinecraftFinder.getMinecraftJar(mcDir, false) == null) {
            mcDir = MinecraftFinder.getDefaultMinecraftDirectory();
        }
        Log.infof("Found Minecraft directory %s", mcDir.getAbsolutePath());
        return mcDir;
    }

    public static File getDefaultMinecraftDirectory() {
        String home = System.getProperty("user.home", ".");
        switch (OSDetector.getOS()) {
            case WIN: {
                String appdata = System.getenv("APPDATA");
                if (appdata != null) {
                    return new File(appdata, ".minecraft");
                }
                return new File(home, ".minecraft");
            }
            case MAC: {
                return new File(home, "Library/Application Support/minecraft");
            }
        }
        return new File(home, ".minecraft");
    }

    public static File getSavesDirectory() {
        return new File(MinecraftFinder.getMinecraftDirectory(), "saves");
    }

    public static File getTexturePacksDirectory() {
        return new File(MinecraftFinder.getMinecraftDirectory(), "texturepacks");
    }

    public static File getResourcePacksDirectory() {
        return new File(MinecraftFinder.getMinecraftDirectory(), "resourcepacks");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getMinecraftJar() {
        Class<MinecraftFinder> clazz = MinecraftFinder.class;
        synchronized (MinecraftFinder.class) {
            if (!foundJar) {
                File jar;
                File resourceDir;
                minecraftJar = MinecraftFinder.getMinecraftJar(MinecraftFinder.getMinecraftDirectory(), true);
                if (minecraftJar == null && (resourceDir = new File(SettingsDirectory.getSettingsDirectory(), "resources")).isDirectory() && (jar = new File(resourceDir, "minecraft.jar")).isFile() && jar.canRead()) {
                    minecraftJar = jar;
                }
                foundJar = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return minecraftJar;
        }
    }

    public static File getMinecraftJarNonNull() throws FileNotFoundException {
        File jarFile = MinecraftFinder.getMinecraftJar();
        if (jarFile == null) {
            throw new FileNotFoundException("Could not locate Minecraft Jar!");
        }
        return jarFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File getMinecraftJar(File mcDir, boolean debug) {
        File bin;
        File versions = new File(mcDir, "versions");
        if (versions.isDirectory()) {
            File[] dirs = versions.listFiles(pathname -> pathname.isDirectory());
            ArrayList<MCVersion> versionDirs = new ArrayList<MCVersion>();
            File[] fileArray = dirs;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File directory = fileArray[i];
                File jarPath = new File(directory, directory.getName() + ".jar");
                if (!jarPath.isFile()) continue;
                String releaseTime = "";
                try {
                    File jsonFile = new File(directory, directory.getName() + ".json");
                    FileInputStream in = new FileInputStream(jsonFile);
                    JsonParser parser = new JsonParser(in);
                    JsonObject obj = parser.parse().object();
                    releaseTime = obj.get("releaseTime").stringValue("");
                    continue;
                }
                catch (IOException | JsonParser.SyntaxError exception) {
                    continue;
                }
                finally {
                    versionDirs.add(new MCVersion(jarPath, releaseTime));
                }
            }
            if (!versionDirs.isEmpty()) {
                MCVersion latest = (MCVersion)versionDirs.get(0);
                for (int i = 1; i < versionDirs.size(); ++i) {
                    if (((MCVersion)versionDirs.get(i)).compareTo(latest) <= 0) continue;
                    latest = (MCVersion)versionDirs.get(i);
                }
                if (debug) {
                    Log.infof("Found latest Minecraft version: %s", latest.jar.getAbsolutePath());
                }
                return latest.jar;
            }
        }
        if ((bin = new File(mcDir, "bin")).isDirectory()) {
            for (File file : bin.listFiles()) {
                if (!file.getName().equalsIgnoreCase("minecraft.jar")) continue;
                return new File(bin, file.getName());
            }
        }
        return null;
    }

    private static class MCVersion
    implements Comparable<MCVersion> {
        private final File jar;
        private final Date timestamp;

        public MCVersion(File jarFile, String time) {
            this.jar = jarFile;
            this.timestamp = Util.dateFromISO8601(time);
        }

        @Override
        public int compareTo(MCVersion other) {
            return this.timestamp.compareTo(other.timestamp);
        }

        public String toString() {
            return this.jar.getName();
        }
    }
}

