/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.resources;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;

public final class SettingsDirectory {
    private static final String SETTINGS_DIR = ".chunky";

    private SettingsDirectory() {
    }

    public static boolean findSettingsDirectory() {
        File directory = SettingsDirectory.getSettingsDirectory();
        return directory != null && directory.isDirectory();
    }

    public static File getSettingsDirectory() {
        String chunkyHomeProperty = System.getProperty("chunky.home");
        if (chunkyHomeProperty != null && !chunkyHomeProperty.isEmpty()) {
            return new File(chunkyHomeProperty);
        }
        File directory = SettingsDirectory.getWorkingDirectory();
        if (SettingsDirectory.isSettingsDirectory(directory)) {
            return directory;
        }
        directory = SettingsDirectory.getProgramDirectory();
        if (SettingsDirectory.isSettingsDirectory(directory)) {
            return directory;
        }
        directory = SettingsDirectory.getHomeDirectory();
        if (SettingsDirectory.isSettingsDirectory(directory)) {
            return directory;
        }
        return null;
    }

    private static boolean isSettingsDirectory(File settingsDir) {
        File settingsFile;
        return settingsDir != null && settingsDir.exists() && settingsDir.isDirectory() && settingsDir.canWrite() && (settingsFile = new File(settingsDir, "chunky.json")).isFile() && settingsFile.canRead();
    }

    public static File getHomeDirectory() {
        String workingDir = System.getProperty("user.home");
        if (workingDir != null && !workingDir.isEmpty()) {
            return new File(workingDir, SETTINGS_DIR);
        }
        return null;
    }

    public static File getWorkingDirectory() {
        String workingDir = System.getProperty("user.dir");
        if (workingDir != null && !workingDir.isEmpty()) {
            return new File(workingDir);
        }
        return null;
    }

    public static File getPluginsDirectory() {
        return new File(SettingsDirectory.getSettingsDirectory(), "plugins");
    }

    public static File getProgramDirectory() {
        URL location = SettingsDirectory.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            File dir = new File(location.toURI());
            if (dir.isFile()) {
                dir = dir.getParentFile();
            }
            return dir;
        }
        catch (URISyntaxException e) {
            return null;
        }
    }
}

