/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.ui;

import java.util.function.Consumer;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.util.StringConverter;
import javafx.util.converter.NumberStringConverter;

public abstract class Adjuster<T extends Number>
extends HBox {
    private final StringProperty name = new SimpleStringProperty("Name");
    protected final Label nameLbl = new Label();
    protected final TextField valueField = new TextField();
    protected final Property<Number> value;
    private ChangeListener<Number> listener;

    protected Adjuster(Property<Number> value) {
        this.value = value;
        this.nameLbl.textProperty().bind((ObservableValue)Bindings.concat((Object[])new Object[]{this.name, ":"}));
        this.setAlignment(Pos.CENTER_LEFT);
        this.setSpacing(10.0);
        this.valueField.setPrefWidth(103.0);
        this.valueField.textProperty().bindBidirectional(value, (StringConverter)new NumberStringConverter());
        this.getChildren().addAll((Object[])new Node[]{this.nameLbl, this.valueField});
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public String getName() {
        return (String)this.name.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public void set(Number newValue) {
        if (this.listener != null) {
            this.value.removeListener(this.listener);
            this.value.setValue((Object)newValue);
            this.value.addListener(this.listener);
        } else {
            this.value.setValue((Object)newValue);
        }
    }

    public void setAndUpdate(Number newValue) {
        this.value.setValue((Object)newValue);
    }

    public T get() {
        return (T)((Number)this.value.getValue());
    }

    public void setTooltip(String tooltip) {
        this.nameLbl.setTooltip(new Tooltip(tooltip));
        this.valueField.setTooltip(new Tooltip(tooltip));
    }

    protected abstract T clamp(Number var1);

    public void onValueChange(Consumer<T> changeConsumer) {
        if (this.listener != null) {
            this.value.removeListener(this.listener);
        }
        this.listener = (observable, oldValue, newValue) -> changeConsumer.accept(this.clamp((Number)newValue));
        this.value.addListener(this.listener);
    }

    public Property<Number> valueProperty() {
        return this.value;
    }
}

