/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.chunky.ui;

import javafx.beans.property.DoubleProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Slider;
import javafx.scene.control.Tooltip;
import se.llbit.chunky.ui.Adjuster;

public abstract class SliderAdjuster<T extends Number>
extends Adjuster<T> {
    private final Slider valueSlider = new Slider();
    private double sliderMin = 0.01;
    private double min = 0.0;
    private double max = 100.0;
    protected boolean clampMax;
    protected boolean clampMin;
    private boolean logarithmic = false;
    private boolean maxInfinity = false;

    protected SliderAdjuster(Property<Number> value) {
        super(value);
        this.setSpacing(10.0);
        this.getChildren().setAll((Object[])new Node[]{this.nameLbl, this.valueSlider, this.valueField});
        this.valueSlider.valueProperty().bindBidirectional(value);
        this.valueSlider.setMin(0.0);
        this.valueSlider.setMax(100.0);
    }

    @Override
    public void setTooltip(String tooltip) {
        super.setTooltip(tooltip);
        this.valueSlider.setTooltip(new Tooltip(tooltip));
    }

    public void setRange(double min, double max) {
        this.sliderMin = min < 0.01 && min >= 0.0 ? 0.01 : min;
        this.min = min;
        this.max = max;
        if (!this.logarithmic) {
            this.valueSlider.setMin(min);
            this.valueSlider.setMax(max);
        }
    }

    public void makeLogarithmic() {
        this.logarithmic = true;
        this.valueSlider.setMin(0.0);
        this.valueSlider.setMax(100.0);
        SimpleDoubleProperty sliderValue = new SimpleDoubleProperty();
        ChangeListener sliderListener = (observable, oldValue, newValue) -> {
            double result;
            if (this.maxInfinity && newValue.doubleValue() > 99.9) {
                result = Double.POSITIVE_INFINITY;
            } else {
                double logMin = Math.log(this.sliderMin);
                double logMax = Math.log(this.max);
                double range = logMax - logMin;
                result = Math.pow(Math.E, newValue.doubleValue() / 100.0 * range + logMin);
            }
            this.value.setValue((Object)result);
        };
        ChangeListener valueListener = (arg_0, arg_1, arg_2) -> this.lambda$makeLogarithmic$1((DoubleProperty)sliderValue, sliderListener, arg_0, arg_1, arg_2);
        sliderValue.addListener(sliderListener);
        this.value.addListener(valueListener);
        this.valueSlider.valueProperty().unbindBidirectional(this.value);
        this.valueSlider.valueProperty().bindBidirectional((Property)sliderValue);
    }

    public void setMaxInfinity(boolean maxInfinity) {
        this.maxInfinity = maxInfinity;
    }

    public void clampBoth() {
        this.clampMax();
        this.clampMin();
    }

    public void clampMax() {
        this.clampMax = true;
    }

    public void clampMin() {
        this.clampMin = true;
    }

    private /* synthetic */ void lambda$makeLogarithmic$1(DoubleProperty sliderValue, ChangeListener sliderListener, ObservableValue observable, Number oldValue, Number newValue) {
        double logMin = Math.log(this.sliderMin);
        double logMax = Math.log(this.max);
        double logValue = Math.log(newValue.doubleValue());
        logValue = Math.max(logMin, logValue);
        logValue = Math.min(logMax, logValue);
        double pos = (logValue - logMin) / (logMax - logMin);
        double result = pos * 100.0;
        sliderValue.removeListener(sliderListener);
        sliderValue.set(result);
        sliderValue.addListener(sliderListener);
    }
}

