/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.io;

import java.io.FilterReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class LookaheadReader
extends FilterReader {
    private static final int BUFF_SIZE = 1024;
    private final int lookahead;
    private final char[] buffer = new char[1024];
    private int pos = 0;
    private int length = 0;

    public LookaheadReader(Reader in, int lookahead) {
        super(in);
        this.lookahead = lookahead;
        if (this.lookahead >= 1024) {
            throw new IllegalArgumentException("Too large lookahead");
        }
    }

    public LookaheadReader(InputStream in, int lookahead) {
        this(new InputStreamReader(in), lookahead);
    }

    @Override
    public long skip(long num) throws IOException {
        this.refill();
        long skipped = Math.min(num, (long)(this.length - this.pos));
        this.pos = (int)((long)this.pos + skipped);
        return skipped;
    }

    public int peek() throws IOException {
        this.refill();
        if (this.pos < this.length) {
            return this.buffer[this.pos];
        }
        return -1;
    }

    public int peek(int index) throws IOException {
        this.refill();
        if (this.pos + index < this.length) {
            return this.buffer[this.pos + index];
        }
        return -1;
    }

    public int pop() throws IOException {
        this.refill();
        if (this.pos < this.length) {
            return this.buffer[this.pos++];
        }
        return -1;
    }

    private void refill() throws IOException {
        if (this.length - this.pos <= this.lookahead) {
            if (this.length - this.pos > 0) {
                System.arraycopy(this.buffer, this.pos, this.buffer, 0, this.length - this.pos);
                this.length -= this.pos;
                this.pos = 0;
            } else {
                this.length = 0;
                this.pos = 0;
            }
            int i = super.read(this.buffer, this.length, 1024 - this.length);
            this.length += i != -1 ? i : 0;
        }
    }

    @Override
    public int read() throws IOException {
        return this.pop();
    }

    @Override
    public int read(char[] cbuf, int offset, int len) throws IOException {
        if (!this.ready()) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c < 0) {
                return i;
            }
            cbuf[offset + i] = (char)c;
        }
        return len;
    }

    @Override
    public boolean ready() throws IOException {
        return this.pos < this.length || super.ready();
    }
}

