/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.json;

import se.llbit.json.JsonLiteral;
import se.llbit.json.JsonNumber;
import se.llbit.json.JsonString;
import se.llbit.json.JsonValue;
import se.llbit.json.PrettyPrinter;

public final class Json {
    public static final JsonLiteral TRUE = new JsonLiteral(){

        @Override
        public void prettyPrint(PrettyPrinter out) {
            out.print("true");
        }

        @Override
        public String toCompactString() {
            return "true";
        }

        public String toString() {
            return "true";
        }

        @Override
        public boolean boolValue(boolean undefined) {
            return true;
        }

        @Override
        public boolean asBoolean(boolean undefined) {
            return true;
        }

        @Override
        public JsonLiteral copy() {
            return this;
        }
    };
    public static final JsonLiteral FALSE = new JsonLiteral(){

        @Override
        public void prettyPrint(PrettyPrinter out) {
            out.print("false");
        }

        @Override
        public String toCompactString() {
            return "false";
        }

        public String toString() {
            return "false";
        }

        @Override
        public boolean boolValue(boolean undefined) {
            return false;
        }

        @Override
        public boolean asBoolean(boolean undefined) {
            return false;
        }

        @Override
        public JsonLiteral copy() {
            return this;
        }
    };
    public static final JsonValue UNKNOWN = new JsonValue(){

        @Override
        public void prettyPrint(PrettyPrinter out) {
            out.print("\"<unknown>\"");
        }

        @Override
        public String toCompactString() {
            return "\"<unknown>\"";
        }

        public String toString() {
            return "\"<unknown>\"";
        }

        @Override
        public boolean isUnknown() {
            return true;
        }

        @Override
        public JsonValue copy() {
            return this;
        }
    };
    public static final JsonLiteral NULL = new JsonLiteral(){

        @Override
        public void prettyPrint(PrettyPrinter out) {
            out.print("null");
        }

        @Override
        public String toCompactString() {
            return "null";
        }

        public String toString() {
            return "null";
        }

        @Override
        public JsonLiteral copy() {
            return this;
        }
    };

    private Json() {
    }

    public static JsonString of(String value) {
        if (value == null) {
            throw new NullPointerException();
        }
        return new JsonString(value);
    }

    public static JsonNumber of(long value) {
        return new JsonNumber(value);
    }

    public static JsonNumber of(double value) {
        return new JsonNumber(value);
    }

    public static JsonValue of(boolean value) {
        return value ? TRUE : FALSE;
    }
}

