/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.json;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.llbit.json.Json;
import se.llbit.json.JsonNumber;
import se.llbit.json.JsonString;
import se.llbit.json.JsonValue;
import se.llbit.json.PrettyPrintable;
import se.llbit.json.PrettyPrinter;

public class JsonArray
extends JsonValue
implements Iterable<JsonValue> {
    public final List<JsonValue> elements;

    public JsonArray() {
        this.elements = new ArrayList<JsonValue>();
    }

    public JsonArray(int initialCapacity) {
        this.elements = new ArrayList<JsonValue>(initialCapacity);
    }

    @Override
    public void prettyPrint(PrettyPrinter out) {
        if (!this.isEmpty()) {
            out.print("[");
            out.println();
            out.indent(1);
            boolean first = true;
            for (PrettyPrintable prettyPrintable : this.elements) {
                if (!first) {
                    out.print(",");
                    out.println();
                }
                first = false;
                out.print(prettyPrintable);
            }
            out.println();
            out.print("]");
        } else {
            out.print("[]");
        }
    }

    public void add(JsonValue value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.elements.add(value);
    }

    public void addAll(JsonValue ... values) {
        if (values == null) {
            throw new NullPointerException();
        }
        for (JsonValue value : values) {
            this.add(value);
        }
    }

    public void add(String value) {
        this.elements.add(new JsonString(value));
    }

    public void add(long value) {
        this.elements.add(new JsonNumber(value));
    }

    public void add(double value) {
        this.elements.add(new JsonNumber(value));
    }

    public void add(boolean value) {
        this.elements.add(value ? Json.TRUE : Json.FALSE);
    }

    public JsonValue get(int index) {
        return this.elements.get(index);
    }

    public JsonValue remove(int i) {
        return this.elements.remove(i);
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (JsonValue element : this.elements) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(element.toCompactString());
        }
        sb.append("]");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[ ");
        boolean first = true;
        for (JsonValue element : this) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(element.toString());
        }
        sb.append(" ]");
        return sb.toString();
    }

    public int size() {
        return this.elements.size();
    }

    public void set(int i, JsonValue value) {
        this.elements.set(i, value);
    }

    @Override
    public boolean isArray() {
        return true;
    }

    @Override
    public JsonArray array() {
        return this;
    }

    @Override
    public JsonArray asArray() {
        return this;
    }

    @Override
    public JsonArray copy() {
        JsonArray copy = new JsonArray(this.elements.size());
        for (JsonValue element : this.elements) {
            copy.add(element.copy());
        }
        return copy;
    }

    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public Iterator<JsonValue> iterator() {
        return this.elements.iterator();
    }

    public int hashCode() {
        int hash = 0;
        for (JsonValue element : this.elements) {
            hash ^= element.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsonArray)) {
            return false;
        }
        JsonArray other = (JsonArray)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).equals(other.get(i))) continue;
            return false;
        }
        return true;
    }
}

