/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.json;

import se.llbit.json.JsonString;
import se.llbit.json.JsonValue;
import se.llbit.json.PrettyPrintable;
import se.llbit.json.PrettyPrinter;

public class JsonMember
implements PrettyPrintable {
    public final String name;
    public final JsonValue value;

    public JsonMember(String name, JsonValue value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public void prettyPrint(PrettyPrinter out) {
        out.print("\"");
        out.print(this.getName());
        out.print("\": ");
        out.print(this.getValue());
    }

    public String toCompactString() {
        return "\"" + JsonString.escape(this.getName()) + "\":" + this.getValue().toCompactString();
    }

    public String toString() {
        return "\"" + this.getName() + "\" : " + this.getValue().toString();
    }

    public String getName() {
        return this.name;
    }

    public JsonValue getValue() {
        return this.value;
    }

    public JsonMember copy() {
        return new JsonMember(this.name, this.value.copy());
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsonMember)) {
            return false;
        }
        JsonMember other = (JsonMember)obj;
        return !(this.name != other.name && !this.name.equals(other.name) || this.value != other.value && !this.value.equals(other.value));
    }
}

