/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.json;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import se.llbit.json.Json;
import se.llbit.json.JsonMember;
import se.llbit.json.JsonNumber;
import se.llbit.json.JsonString;
import se.llbit.json.JsonValue;
import se.llbit.json.PrettyPrintable;
import se.llbit.json.PrettyPrinter;

public class JsonObject
extends JsonValue
implements Iterable<JsonMember> {
    public final List<JsonMember> members;

    public JsonObject() {
        this.members = new ArrayList<JsonMember>();
    }

    public JsonObject(int initialCapacity) {
        this.members = new ArrayList<JsonMember>(initialCapacity);
    }

    @Override
    public void prettyPrint(PrettyPrinter out) {
        if (!this.isEmpty()) {
            out.print("{");
            out.println();
            out.indent(1);
            boolean first = true;
            for (PrettyPrintable prettyPrintable : this.members) {
                if (!first) {
                    out.print(",");
                    out.println();
                }
                first = false;
                out.print(prettyPrintable);
            }
            out.println();
            out.print("}");
        } else {
            out.print("{}");
        }
    }

    public void set(String name, JsonValue value) {
        for (int i = 0; i < this.size(); ++i) {
            if (!this.get(i).getName().equals(name)) continue;
            this.members.set(i, new JsonMember(name, value));
            return;
        }
        this.add(name, value);
    }

    public void set(int i, JsonValue value) {
        this.members.set(i, new JsonMember(this.members.get((int)i).name, value));
    }

    public void add(String name, JsonValue value) {
        if (value == null) {
            throw new NullPointerException();
        }
        this.add(new JsonMember(name, value));
    }

    public void add(String name, String value) {
        this.add(name, new JsonString(value));
    }

    public void add(String name, long value) {
        this.add(name, new JsonNumber(value));
    }

    public void add(String name, double value) {
        this.add(name, new JsonNumber(value));
    }

    public void add(String name, boolean value) {
        this.add(name, value ? Json.TRUE : Json.FALSE);
    }

    @Override
    public String toCompactString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        boolean first = true;
        for (JsonMember member : this.members) {
            if (!first) {
                sb.append(",");
            }
            first = false;
            sb.append(member.toCompactString());
        }
        sb.append("}");
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{ ");
        boolean first = true;
        for (JsonMember member : this.members) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(member.toString());
        }
        sb.append(" }");
        return sb.toString();
    }

    public int size() {
        return this.members.size();
    }

    public JsonMember get(int i) {
        return this.members.get(i);
    }

    public JsonMember remove(int i) {
        return this.members.remove(i);
    }

    public JsonMember remove(String name) {
        for (int i = 0; i < this.members.size(); ++i) {
            if (!this.members.get((int)i).name.equals(name)) continue;
            return this.members.remove(i);
        }
        return null;
    }

    public void add(JsonMember member) {
        if (member == null) {
            throw new NullPointerException();
        }
        this.members.add(member);
    }

    public void addAll(JsonMember ... all) {
        if (all == null) {
            throw new NullPointerException();
        }
        for (JsonMember member : all) {
            this.add(member);
        }
    }

    public Map<String, JsonValue> toMap() {
        HashMap<String, JsonValue> map = new HashMap<String, JsonValue>();
        for (JsonMember member : this.members) {
            if (map.containsKey(member.name)) continue;
            map.put(member.name, member.value);
        }
        return map;
    }

    public JsonValue get(String name) {
        for (JsonMember member : this.members) {
            if (!member.getName().equals(name)) continue;
            return member.getValue();
        }
        return Json.UNKNOWN;
    }

    @Override
    public boolean isObject() {
        return true;
    }

    @Override
    public JsonObject object() {
        return this;
    }

    @Override
    public JsonObject asObject() {
        return this;
    }

    @Override
    public JsonObject copy() {
        JsonObject copy = new JsonObject(this.members.size());
        for (JsonMember member : this.members) {
            copy.add(member.copy());
        }
        return copy;
    }

    public boolean isEmpty() {
        return this.members.isEmpty();
    }

    @Override
    public Iterator<JsonMember> iterator() {
        return this.members.iterator();
    }

    public int hashCode() {
        int hash = 0;
        for (JsonMember member : this.members) {
            hash ^= member.hashCode();
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsonObject)) {
            return false;
        }
        JsonObject other = (JsonObject)obj;
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).equals(other.get(i))) continue;
            return false;
        }
        return true;
    }
}

