/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.json;

import java.io.IOException;
import java.io.InputStream;
import se.llbit.io.LookaheadReader;
import se.llbit.json.Json;
import se.llbit.json.JsonArray;
import se.llbit.json.JsonMember;
import se.llbit.json.JsonNumber;
import se.llbit.json.JsonObject;
import se.llbit.json.JsonString;
import se.llbit.json.JsonValue;

public class JsonParser
implements AutoCloseable {
    private static final int EOF = -1;
    private final LookaheadReader in;

    public JsonParser(InputStream input) {
        this.in = new LookaheadReader(input, 8);
    }

    public JsonValue parse() throws IOException, SyntaxError {
        JsonValue value;
        this.skipWhitespace();
        switch (this.in.peek()) {
            case 123: {
                value = this.parseObject();
                break;
            }
            case 91: {
                value = this.parseArray();
                break;
            }
            default: {
                throw new SyntaxError("expected JSON object or array");
            }
        }
        this.skipWhitespace();
        if (this.in.peek() != -1) {
            throw new SyntaxError(String.format("garbage at end of input (unexpected '%c')", Character.valueOf((char)this.in.peek())));
        }
        return value;
    }

    private JsonArray parseArray() throws IOException, SyntaxError {
        this.accept('[');
        JsonArray array = new JsonArray();
        do {
            this.skipWhitespace();
            JsonValue value = this.parseValue();
            if (value == null) {
                if (array.isEmpty() && this.in.peek() != 44) break;
                throw new SyntaxError("missing element in array");
            }
            array.add(value);
            this.skipWhitespace();
        } while (this.skip(','));
        this.accept(']');
        return array;
    }

    private JsonValue parseValue() throws IOException, SyntaxError {
        switch (this.in.peek()) {
            case 123: {
                return this.parseObject();
            }
            case 91: {
                return this.parseArray();
            }
            case 43: 
            case 45: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return this.parseNumber();
            }
            case 34: {
                return new JsonString(this.parseString());
            }
            case 116: {
                this.acceptLiteral(Literal.TRUE);
                return Json.TRUE;
            }
            case 102: {
                this.acceptLiteral(Literal.FALSE);
                return Json.FALSE;
            }
            case 110: {
                this.acceptLiteral(Literal.NULL);
                return Json.NULL;
            }
        }
        return null;
    }

    private String parseString() throws IOException, SyntaxError {
        this.accept('\"');
        StringBuilder sb = new StringBuilder();
        while (true) {
            int next;
            if ((next = this.in.pop()) == -1) {
                throw new SyntaxError("end of input while parsing JSON string (expected '\"')");
            }
            if (next == 92) {
                sb.append(this.unescapeStringChar());
                continue;
            }
            if (next == 34) break;
            sb.append((char)next);
        }
        return sb.toString();
    }

    private char unescapeStringChar() throws IOException, SyntaxError {
        int next = this.in.pop();
        switch (next) {
            case 34: {
                return '\"';
            }
            case 92: {
                return '\\';
            }
            case 47: {
                return '/';
            }
            case 98: {
                return '\b';
            }
            case 102: {
                return '\f';
            }
            case 110: {
                return '\n';
            }
            case 114: {
                return '\r';
            }
            case 116: {
                return '\t';
            }
            case 117: {
                int[] u = new int[]{this.hexDigit(), this.hexDigit(), this.hexDigit(), this.hexDigit()};
                return (char)(u[0] << 12 | u[1] << 8 | u[2] << 4 | u[3]);
            }
            case -1: {
                throw new SyntaxError("end of input in JSON string escape sequence.");
            }
        }
        throw new SyntaxError(String.format("illegal escape sequence in JSON string: \\%c. Expected one of \\n, \\r, \\t, etc.", Character.valueOf((char)next)));
    }

    private int hexDigit() throws IOException, SyntaxError {
        int next = this.in.pop();
        int v1 = next - 48;
        int v2 = next - 65 + 10;
        int v3 = next - 97 + 10;
        if (v1 >= 0 && v1 <= 9) {
            return v1;
        }
        if (v2 >= 10 && v2 <= 15) {
            return v2;
        }
        if (v3 >= 10 && v3 <= 15) {
            return v3;
        }
        throw new SyntaxError(String.format("in JSON string: non-hexadecimal digit '%c' in Unicode escape sequence.", Character.valueOf((char)next)));
    }

    private JsonValue parseNumber() throws IOException, SyntaxError {
        StringBuilder sb = new StringBuilder();
        block4: while (true) {
            switch (this.in.peek()) {
                case -1: {
                    throw new SyntaxError("end of input while parsing JSON number.");
                }
                case 43: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 69: 
                case 101: {
                    sb.append((char)this.in.pop());
                    continue block4;
                }
            }
            break;
        }
        return new JsonNumber(sb.toString());
    }

    private void skipWhitespace() throws IOException {
        while (this.isWhitespace(this.in.peek())) {
            this.in.pop();
        }
    }

    private boolean isWhitespace(int chr) {
        return chr == 32 || chr == 9 || chr == 10 || chr == 13;
    }

    private void acceptLiteral(char[] literal) throws IOException, SyntaxError {
        for (char c : literal) {
            if (this.in.pop() == c) continue;
            throw new SyntaxError("encountered invalid JSON literal");
        }
    }

    private JsonObject parseObject() throws IOException, SyntaxError {
        this.accept('{');
        JsonObject object = new JsonObject();
        do {
            this.skipWhitespace();
            JsonMember member = this.parseMember();
            if (member == null) {
                int next = this.in.peek();
                if (next == -1 || next != 44 && next == 125) break;
                throw new SyntaxError("missing member in object.");
            }
            object.add(member);
            this.skipWhitespace();
        } while (this.skip(','));
        this.accept('}');
        return object;
    }

    private boolean skip(char c) throws IOException, SyntaxError {
        boolean skip;
        boolean bl = skip = this.in.peek() == c;
        if (skip) {
            this.in.pop();
        }
        return skip;
    }

    private void accept(char c) throws IOException, SyntaxError {
        int next = this.in.pop();
        if (next == -1) {
            throw new SyntaxError(String.format("unexpected end of input (expected '%c')", Character.valueOf(c)));
        }
        if (next != c) {
            throw new SyntaxError(String.format("unexpected character (was '%c', expected '%c')", Character.valueOf((char)next), Character.valueOf(c)));
        }
    }

    private JsonMember parseMember() throws IOException, SyntaxError {
        if (this.in.peek() == 34) {
            String name = this.parseString();
            this.skipWhitespace();
            this.accept(':');
            this.skipWhitespace();
            JsonValue value = this.parseValue();
            if (value == null) {
                throw new SyntaxError("missing value for object member");
            }
            return new JsonMember(name, value);
        }
        return null;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public static class SyntaxError
    extends Exception {
        public SyntaxError(String message) {
            super("Syntax Error: " + message);
        }
    }

    static interface Literal {
        public static final char BEGIN_OBJECT = '{';
        public static final char END_OBJECT = '}';
        public static final char BEGIN_ARRAY = '[';
        public static final char END_ARRAY = ']';
        public static final char NAME_SEPARATOR = ':';
        public static final char VALUE_SEPARATOR = ',';
        public static final char[] TRUE = "true".toCharArray();
        public static final char[] FALSE = "false".toCharArray();
        public static final char[] NULL = "null".toCharArray();
        public static final char QUOTE_MARK = '\"';
        public static final char ESCAPE = '\\';
    }
}

