/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.json;

import se.llbit.json.JsonValue;
import se.llbit.json.PrettyPrinter;

public class JsonString
extends JsonValue {
    public final String value;

    public JsonString(String value) {
        this.value = value;
    }

    @Override
    public void prettyPrint(PrettyPrinter out) {
        out.print("\"");
        out.print(this.escaped());
        out.print("\"");
    }

    @Override
    public String toCompactString() {
        return "\"" + this.escaped() + "\"";
    }

    public String toString() {
        return "\"" + this.value + "\"";
    }

    @Override
    public String stringValue(String undefined) {
        return this.value;
    }

    @Override
    public String asString(String undefined) {
        return this.value;
    }

    @Override
    public JsonString copy() {
        return this;
    }

    public String escaped() {
        return JsonString.escape(this.value);
    }

    protected static String escape(String string) {
        int cp;
        for (int i = 0; i < string.length(); i += Character.charCount(cp)) {
            cp = string.codePointAt(i);
            switch (cp) {
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 34: 
                case 92: {
                    return JsonString.doStringEscape(string);
                }
            }
        }
        return string;
    }

    protected static String doStringEscape(String string) {
        int cp;
        StringBuilder sb = new StringBuilder();
        block9: for (int i = 0; i < string.length(); i += Character.charCount(cp)) {
            cp = string.codePointAt(i);
            switch (cp) {
                case 34: {
                    sb.append("\\\"");
                    continue block9;
                }
                case 92: {
                    sb.append("\\\\");
                    continue block9;
                }
                case 10: {
                    sb.append("\\n");
                    continue block9;
                }
                case 13: {
                    sb.append("\\r");
                    continue block9;
                }
                case 9: {
                    sb.append("\\t");
                    continue block9;
                }
                case 8: {
                    sb.append("\\b");
                    continue block9;
                }
                case 12: {
                    sb.append("\\f");
                    continue block9;
                }
            }
            sb.appendCodePoint(cp);
        }
        return sb.toString();
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof JsonString)) {
            return false;
        }
        JsonString other = (JsonString)obj;
        return this.value == other.value || this.value.equals(other.value);
    }
}

