/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.json;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import se.llbit.json.PrettyPrintable;

public class PrettyPrinter
implements AutoCloseable {
    private final String indentation;
    private final List<String> ind = new ArrayList<String>(32);
    private final Stack<Integer> indentStack;
    private int currentIndent;
    private final PrintStream out;
    private boolean newline;

    public PrettyPrinter(String ind, PrintStream target) {
        this.ind.add("");
        this.indentStack = new Stack();
        this.indentStack.push(0);
        this.currentIndent = 0;
        this.newline = false;
        this.indentation = ind;
        this.out = target;
    }

    public String getIndentation(int level) {
        while (this.ind.size() < level + 1) {
            this.ind.add(this.ind.get(this.ind.size() - 1) + this.indentation);
        }
        return this.ind.get(level);
    }

    public void print(String str) {
        this.indentNewline();
        this.out.print(str);
    }

    public void println() {
        this.out.println();
        this.newline = true;
    }

    public void print(PrettyPrintable node) {
        this.pushIndentation();
        node.prettyPrint(this);
        this.popIndentation();
    }

    public void indent(int level) {
        this.indentNewline();
        this.currentIndent = level;
        this.out.print(this.getIndentation(level));
    }

    private void pushIndentation() {
        this.indentStack.push(this.currentIndent + this.indentStack.peek());
        this.currentIndent = 0;
    }

    private void popIndentation() {
        this.currentIndent = this.indentStack.pop();
        this.currentIndent -= this.indentStack.peek().intValue();
    }

    private void indentNewline() {
        if (this.newline) {
            this.out.print(this.getIndentation(this.indentStack.peek()));
            this.newline = false;
        }
    }

    @Override
    public void close() {
        this.out.close();
    }
}

