/*
 * Decompiled with CFR 0.152.
 */
package se.llbit.math;

public class QuickMath {
    public static final double HALF_PI = 1.5707963267948966;
    public static final double TAU = Math.PI * 2;

    public static long floor(double d) {
        long i = (long)d;
        return d < (double)i ? i - 1L : i;
    }

    public static long ceil(double d) {
        long i = (long)d;
        return d > (double)i ? i + 1L : i;
    }

    public static int nextPow2(int x) {
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public static int log2(int x) {
        int v = 0;
        while ((x >>>= 1) != 0) {
            ++v;
        }
        return v;
    }

    public static int signum(double x) {
        return x < 0.0 ? -1 : 1;
    }

    public static int signum(float x) {
        return x < 0.0f ? -1 : 1;
    }

    public static double radToDeg(double rad) {
        return 180.0 * (rad / Math.PI);
    }

    public static double modulo(double value, double mod) {
        return (value % mod + mod) % mod;
    }

    public static double degToRad(double deg) {
        return deg * Math.PI / 180.0;
    }

    public static double clamp(double value, double min, double max) {
        return value < min ? min : (value > max ? max : value);
    }

    public static double max(double a, double b) {
        return a > b ? a : b;
    }

    public static float max(float a, float b) {
        return a > b ? a : b;
    }

    public static double min(double a, double b) {
        return a < b ? a : b;
    }

    public static float min(float a, float b) {
        return a < b ? a : b;
    }

    public static float abs(float x) {
        return x < 0.0f ? -x : x;
    }

    public static double abs(double x) {
        return x < 0.0 ? -x : x;
    }
}

