local require = GLOBAL.require
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local STRINGS = GLOBAL.STRINGS
local ACTIONS = GLOBAL.ACTIONS
local TECH = GLOBAL.TECH

PrefabFiles = {
	"sin", "ty",
"gg",
}

Assets = {
	Asset("ANIM", "anim/ty.zip"),
	Asset("SOUND", "sound/ty.fsb"),
	Asset("SOUNDPACKAGE", "sound/ty.fev"),
	Asset("ATLAS", "images/inventoryimages/ty.xml"),
    Asset("IMAGE", "images/inventoryimages/ty.tex"),

Asset("ANIM", "anim/gg.zip"),
	Asset("ANIM", "anim/swap_gg.zip"),
	Asset("ATLAS", "images/inventoryimages/gg.xml"),
	Asset("IMAGE", "images/inventoryimages/gg.tex"),

Asset("ANIM", "anim/sin.zip"),
	Asset("ATLAS", "images/inventoryimages/sin.xml"),
    Asset("IMAGE", "images/inventoryimages/sin.tex"),
Asset("SOUND", "sound/mzz.fsb"),
	Asset("SOUNDPACKAGE", "sound/mzz.fev"),
}

RemapSoundEvent( "mzz/play", "mzz/sound/play" )
RemapSoundEvent( "mzz/end", "mzz/sound/end" )

RemapSoundEvent( "ty/play", "ty/sound/play" )
RemapSoundEvent( "ty/end", "ty/sound/end" )


 local sin = GLOBAL.Recipe("sin",
         {
                Ingredient("boards", 3), Ingredient("cutstone", 3), Ingredient("transistor", 1) 
        },
        RECIPETABS.SCIENCE, TECH.SCIENCE_TWO, nil, "sin_placer" )
        sin.atlas = "images/inventoryimages/sin.xml"
        sin.image = "sin.tex"


 local ty = GLOBAL.Recipe("ty",
         {
                Ingredient("boards", 3), Ingredient("cutstone", 3), Ingredient("transistor", 1) 
        },
        RECIPETABS.SCIENCE, TECH.SCIENCE_TWO, nil, "ty_placer" )
        ty.atlas = "images/inventoryimages/ty.xml"
        ty.image = "ty.tex"

local gg = GLOBAL.Recipe("gg", {  Ingredient("cutgrass", 3), Ingredient("twigs", 2) }, RECIPETABS.LIGHT, TECH.NONE)
		gg.atlas = "images/inventoryimages/gg.xml"    


if GetModConfigData("Language") == true then
GLOBAL.STRINGS.RECIPE_DESC.SIN = "" 
GLOBAL.STRINGS.NAMES.SIN = "輧"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SIN = "һ׿׿"


GLOBAL.STRINGS.RECIPE_DESC.TY = "" 
GLOBAL.STRINGS.NAMES.TY = "輧"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.TY = ""

GLOBAL.STRINGS.NAMES.GG = " "
GLOBAL.STRINGS.RECIPE_DESC.GG = "һ˦ "
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.GG = " "

end

if GetModConfigData("Language") == false then
GLOBAL.STRINGS.RECIPE_DESC.SIN = "Music!" 
GLOBAL.STRINGS.NAMES.SIN = "Miku jukebox"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.SIN = "Miku miku mi"


GLOBAL.STRINGS.RECIPE_DESC.TY = "Music!" 
GLOBAL.STRINGS.NAMES.TY = "TianYi jukebox"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.TY = "She is hungry"

GLOBAL.STRINGS.NAMES.GG = "Green onions "
GLOBAL.STRINGS.RECIPE_DESC.GG = "Wave it with miku "
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.GG = "Great "

end