local assets=
{
	Asset("ANIM", "anim/gg.zip"),
	Asset("ANIM", "anim/swap_gg.zip"),
    Asset("IMAGE", "images/inventoryimages/gg.tex"),
	Asset("ATLAS", "images/inventoryimages/gg.xml"),

}



local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_gg", "swap_nightmaresword")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
inst.Light:Enable(true)
inst.components.equippable.dapperness = TUNING.DAPPERNESS_TINY
end

local function onunequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
inst.Light:Enable(false)
end

local function fn()
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
inst.entity:AddLight()


    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("nightmaresword")
    inst.AnimState:SetBuild("gg")
    inst.AnimState:PlayAnimation("idle")


	inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(10)

     inst:AddTag("show_spoilage")
    inst:AddTag("icebox_valid")

   inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/gg.xml"
	
	

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )


inst.entity:AddLight()
		inst.Light:SetRadius(1)
		inst.Light:SetFalloff(0.3)
		inst.Light:SetIntensity(0.9)
		inst.Light:SetColour(2/255,255/255,2/255)

    return inst
end

return Prefab( "common/inventory/gg", fn, assets)
