assets = 
{
	Asset("ANIM", "anim/ty.zip"),
	Asset("SOUND", "sound/ty.fsb"),
}

local prefabs =
{
    
}

local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
    SpawnPrefab("collapse_big").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")


	 inst:Remove()
	
end

local function onhit(inst, worker)
	inst.AnimState:PushAnimation("idle", true)
   
end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("idle", true)
end


local function play(inst)
	inst.AnimState:PlayAnimation("loop", true)
   	inst.SoundEmitter:PlaySound(inst.songToPlay, "ty/play")
   	inst:PushEvent("turnedon")
inst:AddComponent("sanityaura")
	inst.components.sanityaura.aura = TUNING.SANITYAURA_SMALL
inst.Light:Enable(true)
end

local function stop(inst)
	inst.AnimState:PlayAnimation("idle", true)
 inst.SoundEmitter:KillSound("ty/play")
    inst.SoundEmitter:PlaySound("ty/end")

    inst:PushEvent("turnedoff")
inst:RemoveComponent("sanityaura")
inst.Light:Enable(false)
end

local function fn()
		local inst = CreateEntity()
		local trans = inst.entity:AddTransform()
		local anim = inst.entity:AddAnimState()
		local sound = inst.entity:AddSoundEmitter()
		local shadow = inst.entity:AddDynamicShadow()
    shadow:SetSize(3.7,3)
	    MakeObstaclePhysics(inst, 0.5)
		anim:SetBank("ty")
		anim:SetBuild("ty")		
		anim:PlayAnimation("idle", true)
		
		



inst.songToPlay = "ty/play"
		inst:AddComponent("inspectable")
		inst:AddComponent("machine")
		inst.components.machine.turnonfn = play
		inst.components.machine.turnofffn = stop



inst.entity:AddLight()
		inst.Light:SetRadius(2)
		inst.Light:SetFalloff(0.3)
		inst.Light:SetIntensity(0.9)
		inst.Light:SetColour(2/255,2/255,230/255)

inst:AddComponent("lootdropper")
        inst:AddComponent("workable")
        inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
        inst.components.workable:SetWorkLeft(3)
        inst.components.workable:SetOnFinishCallback(onhammered)
        inst.components.workable:SetOnWorkCallback(onhit)     
inst:ListenForEvent("onbuilt", onbuilt)
	 MakeSnowCovered(inst) 
		
	return inst
end

return Prefab("common/objects/ty", fn, assets),
	MakePlacer("common/objects/ty_placer", "ty", "ty", "place")

