local assets=
{
	Asset("ANIM", "anim/c.zip"),
        Asset("IMAGE", "images/inventoryimages/c.tex"),
	Asset("ATLAS", "images/inventoryimages/c.xml"),
}

	local function fn(Sim)
		local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		MakeInventoryPhysics(inst)
		
		inst.AnimState:SetBank("carrot")
		inst.AnimState:SetBuild("c")
		inst.AnimState:PlayAnimation("idle")
		inst.AnimState:SetRayTestOnBB(true);
	    
	        inst:AddComponent("stackable")
		inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

		inst:AddComponent("perishable")
		inst.components.perishable:SetPerishTime(TUNING.PERISH_SUPERSLOW)
		inst.components.perishable:StartPerishing()
		inst.components.perishable.onperishreplacement = "spoiled_food"
	    
		inst:AddComponent("edible")
		inst.components.edible.healthvalue = 20
		inst.components.edible.hungervalue = 5
		inst.components.edible.sanityvalue = 40
		inst.components.edible.foodtype = "VEGGIE"
		
		inst:AddComponent("inspectable")
		
local function OnDeploy (inst, pt)
    SpawnPrefab("yc").Transform:SetPosition(pt.x, pt.y, pt.z)
    inst.components.stackable:Get():Remove()
end
    		inst:AddComponent("deployable")
    		inst.components.deployable.ondeploy = OnDeploy

		inst:AddComponent("inventoryitem")
		inst.components.inventoryitem.atlasname = "images/inventoryimages/c.xml"

		inst:AddComponent("cookable")
    		inst.components.cookable.product = "kc"
		
		inst:AddComponent("tradable")
    		inst.components.tradable.goldvalue = 3

    return inst
end

return Prefab( "common/inventory/c", fn, assets) 
