local assets=
{
	Asset("ANIM", "anim/kc.zip"),
        Asset("IMAGE", "images/inventoryimages/kc.tex"),
	Asset("ATLAS", "images/inventoryimages/kc.xml"),
}

	local function fn(Sim)
		local inst = CreateEntity()
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		MakeInventoryPhysics(inst)
		
		inst.AnimState:SetBank("seeds")
		inst.AnimState:SetBuild("kc")
		inst.AnimState:PlayAnimation("cooked")
	    
	        inst:AddComponent("stackable")
		inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

                inst:AddComponent("bait")

		inst:AddComponent("perishable")
		inst.components.perishable:SetPerishTime(TUNING.PERISH_SUPERSLOW)
		inst.components.perishable:StartPerishing()
		inst.components.perishable.onperishreplacement = "spoiled_food"
	    
		inst:AddComponent("edible")
		inst.components.edible.healthvalue = 10
		inst.components.edible.hungervalue = 30
		inst.components.edible.sanityvalue = 35
		inst.components.edible.foodtype = "VEGGIE"
		
		inst:AddComponent("inspectable")
		inst:AddComponent("inventoryitem")
		inst.components.inventoryitem.atlasname = "images/inventoryimages/kc.xml"

		inst:AddComponent("tradable")
    		inst.components.tradable.goldvalue = 4

    return inst
end

return Prefab( "common/inventory/kc", fn, assets) 
