
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/miku.zip" ),
}
local prefabs = { "c" }

local start_inv = { "c","c","c","c","c","c","c","c","c","c",}

local function applyupgrades(inst)
	local max_upgrades = 3
	local upgrades = math.min(inst.level, max_upgrades)
	inst.components.hunger.max = math.ceil(TUNING.MIKU_MAXHUNGER - upgrades * 30)	
end

local function updatestats(inst)
	if GetClock():IsDay() then
		inst.level = 0
		applyupgrades(inst)
	end
end

local function onsave(inst, data)
	data.level = inst.level
end

local function onpreload(inst, data)
    	if data then
		if data.level then
			inst.level = data.level
			applyupgrades(inst)
		end
	end
end


local function OnAttacked(inst)
    if math.random() < 0.5 then 
    inst.components.health:DoDelta(-10)
    inst.components.talker:Say("~")
    local player = GetPlayer()
    local gifts = {"gears", "gears", "gears", "gears", "transistor", "transistor", "transistor", "thulecite_pieces", "thulecite", "greengem", "thulecite_pieces",}
    inst.gift = gifts[math.random(#gifts)]
    SpawnPrefab(inst.gift).Transform:SetPosition(player.Transform:GetWorldPosition())
    end
end
	

local function OnEat(inst, food)
	if food and food.components.edible and food.prefab == "c" or food.prefab == "kc" or food.prefab == "yc" then
	inst.components.talker:Say("oishi~")
		if inst.components.locomotor.walkspeed < 15 and inst.components.locomotor.runspeed < 15 then
		inst.components.locomotor.runspeed = inst.components.locomotor.runspeed+3
		inst.components.locomotor.walkspeed = inst.components.locomotor.walkspeed+3
		inst:DoTaskInTime(60, function()
		inst.components.locomotor.runspeed = inst.components.locomotor.runspeed-3
		inst.components.locomotor.walkspeed = inst.components.locomotor.walkspeed-3
        	end )	
		end
	end
end


local fn = function(inst)	
	
	-- choose which sounds this character will play
	inst.soundsname = "willow"

	-- a minimap icon must be specified
	inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "miku1.tex" )

	-- todo: Add an example special power here.

	inst.level = 0

	inst.components.health.maxhealth = 100
	inst.components.sanity.max = 100
	inst.components.health.absorb = 0.25
	
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 0.5)
	inst.components.combat:SetAttackPeriod(0.1)
	
	inst.components.locomotor.walkspeed = 6.5
    	inst.components.locomotor.runspeed = 6.5

	inst.components.sanity.neg_aura_mult = 6

	inst.components.eater:SetOnEatFn(OnEat)
	applyupgrades(inst)
	inst:ListenForEvent("attacked", OnAttacked)
	inst:ListenForEvent( "daytime", function() updatestats(inst) end , GetWorld())

	inst.OnSave = onsave
	inst.OnPreLoad = onpreload

TheInput:AddKeyUpHandler(KEY_V, function()--֮
	if TheInput:IsKeyDown(KEY_CTRL) then
		if inst.components.hunger.current < 30 then
		inst.components.talker:Say("miku̫ˣ볪衣")
		else
		inst.level = inst.level + 1
		inst.components.sanity:DoDelta(20)
		inst.components.health:DoDelta(20)
		inst.components.hunger:DoDelta(-30)
		applyupgrades(inst)
		inst.components.talker:Say("~~~~")
		local player = GetPlayer()
    		local pos = Vector3(player.Transform:GetWorldPosition())
    		local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 30)
    	    		 for k,v in pairs(ents) do
        			if v.components.pickable then
           			v.components.pickable:FinishGrowing()
        			end
        			if v.components.crop then
           			v.components.crop:DoGrow(TUNING.TOTAL_DAY_TIME*3)
        			end
        			if v:HasTag("tree") and v.components.growable and not v:HasTag("stump") then
           			v.components.growable:DoGrowth()
        			end
             		end
		end
    	end
end)

TheInput:AddKeyUpHandler(KEY_B, function()--Ѱ֮
    if TheInput:IsKeyDown(KEY_CTRL) then	
	if inst.components.hunger.current < 30 then
	inst.components.talker:Say("miku̫ˣ볪衣")
	else
	inst.level = inst.level + 1
	inst.components.sanity:DoDelta(20)
	inst.components.talker:Say("~~~~")
	inst.components.hunger:DoDelta(-30)
	applyupgrades(inst)
	inst.SoundEmitter:PlaySound("dontstarve/common/makeFriend")
	local player = GetPlayer()
    	local pos = Vector3(player.Transform:GetWorldPosition())
    	local ents = TheSim:FindEntities(pos.x,pos.y,pos.z, 25)
    	    for k,v in pairs(ents) do
		if v.components.combat then 
			if v.components.combat.target and v.components.combat.target == player then
                	v.components.combat:SetTarget(nil)
			end
		end
		if v:HasTag("pig") or v:HasTag("animal") and v.components.follower and not v.components.follower.leader and not player.components.leader:IsFollower(v) then
		player.components.leader:AddFollower(v)
		v.components.follower.canaccepttarget = true
		end
            end
	end
    end
end)
 
end

-- strings! Any "MIKU" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.miku = "ż"
STRINGS.CHARACTER_NAMES.miku = "Hatsune Miku"
STRINGS.CHARACTER_DESCRIPTIONS.miku = "*δƼ\n*ĸλCTRL+VB)\n*ϲ,"
STRINGS.CHARACTER_QUOTES.miku = "\"Ӻÿ\""

-- You can also add any kind of custom dialogue that you would like. Don't forget to make
-- categores that don't exist yet using = {}
-- note: these are UPPER-CASE charcacter name
STRINGS.CHARACTERS.MIKU=require "speech_wendy"
STRINGS.CHARACTERS.MIKU.ANNOUNCE_ADVENTUREFAIL  = ",Ҳ. "

STRINGS.CHARACTERS.MIKU.ANNOUNCE_BOOMERANG  = "Ӧͼץס"
STRINGS.CHARACTERS.MIKU.ANNOUNCE_CHARLIE  = "ʲô "
STRINGS.CHARACTERS.MIKU.ANNOUNCE_CHARLIE_ATTACK = "жҧ! "

STRINGS.CHARACTERS.MIKU.ANNOUNCE_COLD  = "."
STRINGS.CHARACTERS.MIKU.ANNOUNCE_CRAFTING_FAIL  = "ȱٱҪĲ."
STRINGS.CHARACTERS.MIKU.ANNOUNCE_DUSK = "Ϧ."
STRINGS.CHARACTERS.MIKU.ANNOUNCE_CRAFTING_FAIL  = "Ҳ߱Դ. "
STRINGS.CHARACTERS.MIKU.ANNOUNCE_HUNGRY  = "Щ."
STRINGS.CHARACTERS.MIKU.ANNOUNCE_HUNT_BEAST_NEARBY = "! "
STRINGS.CHARACTERS.MIKU.ANNOUNCE_HUNT_LOST_TRAIL  = "Ѿʧȥټ."
STRINGS.CHARACTERS.MIKU.ANNOUNCE_INV_FULL  = "װ. "
STRINGS.CHARACTERS.MIKU.ANNOUNCE_KNOCKEDOUT  = "... "
STRINGS.CHARACTERS.MIKU.ANNOUNCE_NODANGERSLEEP  = "Ҳ˯,й."
STRINGS.CHARACTERS.MIKU.ANNOUNCE_NOHUNGERSLEEP  = "˯,ҿܻԶ޷."
STRINGS.CHARACTERS.MIKU.ANNOUNCE_NODAYSLEEP  = "MIKUڻ. "
STRINGS.CHARACTERS.MIKU.ANNOUNCE_NO_TRAP  = "ɹ! "
STRINGS.CHARACTERS.MIKU.ANNOUNCE_PECKED  = "Ҫ~ "
STRINGS.CHARACTERS.MIKU.ANNOUNCE_QUAKE = " ? "
STRINGS.CHARACTERS.MIKU.ANNOUNCE_RESEARCH  = "ѧһЩ. "
STRINGS.CHARACTERS.MIKU.ANNOUNCE_TORCH_OUT  = "Ļ."
STRINGS.CHARACTERS.MIKU.ANNOUNCE_TRAP_WENT_OFF  = " ? ! "
STRINGS.CHARACTERS.MIKU.ANNOUNCE_WORMHOLE  = "ֵĶ."

STRINGS.CHARACTERS.MIKU.ANNOUNCE_EAT = {}
STRINGS.CHARACTERS.MIKU.ANNOUNCE_EAT.GENERIC  = "MIKUɲϲ. "
STRINGS.CHARACTERS.MIKU.ANNOUNCE_EAT.PAINFULL = "ɲMIKUܳԵ. "
STRINGS.CHARACTERS.MIKU.ANNOUNCE_EAT.SPOILED = "ȫܳ."
STRINGS.CHARACTERS.MIKU.ANNOUNCE_EAT.STALE  = "ƺеζ. "


-- Battle
STRINGS.CHARACTERS.MIKU.ANNOUNCE_HOUNDS  = "£"
STRINGS.CHARACTERS.MIKU.ANNOUNCE_DEERCLOPS  = "̫Σ!"

STRINGS.CHARACTERS.MIKU.BATTLECRY = {}
STRINGS.CHARACTERS.MIKU.BATTLECRY.GENERIC  = "ܱǸΪ!"
STRINGS.CHARACTERS.MIKU.BATTLECRY.PIG = "ԲС."
STRINGS.CHARACTERS.MIKU.BATTLECRY.PREY  = "ԲˣС "
STRINGS.CHARACTERS.MIKU.BATTLECRY.SPIDER  = "MIKUϲ֩롣"
STRINGS.CHARACTERS.MIKU.BATTLECRY.SPIDER_WARRIOR  = "֩룡"
STRINGS.CHARACTERS.MIKU.BATTLECRY.HOUND  = "µ."
STRINGS.CHARACTERS.MIKU.BATTLECRY.LEIF  = "ô."

STRINGS.CHARACTERS.MIKU.COMBAT_QUIT = {}
STRINGS.CHARACTERS.MIKU.COMBAT_QUIT.PIG = "Ҳ."
STRINGS.CHARACTERS.MIKU.COMBAT_QUIT.PREY  = "޷."
STRINGS.CHARACTERS.MIKU.COMBAT_QUIT.SPIDER_WARRIOR  = "Ҳ׷."

-- Description
STRINGS.CHARACTERS.MIKU.DESCRIBE = {}
STRINGS.CHARACTERS.MIKU.DESCRIBE.SLURPER  = "һֲõԤ."
STRINGS.CHARACTERS.MIKU.DESCRIBE.ORANGEAMULET  = "δ̬...֪ι. "
STRINGS.CHARACTERS.MIKU.DESCRIBE.YELLOWSTAFF  = "ĳʽĹӰħأ "
STRINGS.CHARACTERS.MIKU.DESCRIBE.YELLOWGEM  = "һƱʯ. "
STRINGS.CHARACTERS.MIKU.DESCRIBE.ORANGEGEM  = "һɫıʯ. "
STRINGS.CHARACTERS.MIKU.DESCRIBE.STAFFLIGHT  = "⿴Σ. "
STRINGS.CHARACTERS.MIKU.DESCRIBE.RESEARCHLAB4  = "Ŷ,ҵ......ң "
STRINGS.CHARACTERS.MIKU.DESCRIBE.ANCIENT_ALTAR  = "𲻺."
STRINGS.CHARACTERS.MIKU.DESCRIBE.CAVE_BANANA  = "һ㽶"
STRINGS.CHARACTERS.MIKU.DESCRIBE.CAVE_BANANA_COOKED  = "ҴûԹը㽶,ϣҿ. "
STRINGS.CHARACTERS.MIKU.DESCRIBE.CAVE_BANANA_TREE  = ",ûй⣿ "
STRINGS.CHARACTERS.MIKU.DESCRIBE.ROCKY  = "! "
STRINGS.CHARACTERS.MIKU.DESCRIBE.EVERGREEN = "質ļ."


return MakePlayerCharacter("miku", prefabs, assets, fn , start_inv)
