
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/chillywilly.zip" ),
        Asset( "ANIM", "anim/ghost_chillywilly_build.zip" ),
}
local prefabs = {}
local start_inv = {"tophat"
	-- Custom starting items
}

--eat spc
local function oneat(inst, food)
	--
	if food and food.components.edible and food.prefab == "fish"  then
		inst.components.hunger:DoDelta(food.components.edible:GetHunger(inst)*0.3);
		inst.components.sanity:DoDelta(10);
		inst.components.health:DoDelta((food.components.edible:GetHealth(inst)+1)*2, nil, food.prefab);
	end
	if food and food.components.edible and food.prefab == "eel"  then
		inst.components.hunger:DoDelta(food.components.edible:GetHunger(inst)*0.3);
		inst.components.sanity:DoDelta(10);
		inst.components.health:DoDelta((food.components.edible:GetHealth(inst))*2, nil, food.prefab);
	end
	if food and food.components.edible and food.prefab == "fish_cooked"  then
		inst.components.hunger:DoDelta(food.components.edible:GetHunger(inst)*0.3);
		inst.components.sanity:DoDelta(14);
		inst.components.health:DoDelta((food.components.edible:GetHealth(inst)+2)*2, nil, food.prefab);
	end
	if food and food.components.edible and food.prefab == "eel_cooked"  then
		inst.components.hunger:DoDelta(food.components.edible:GetHunger(inst)*0.3);
		inst.components.sanity:DoDelta(14);
		inst.components.health:DoDelta(food.components.edible:GetHealth(inst), nil, food.prefab);
	end
	if food and food.components.edible and food.prefab == "unagi"  then
		inst.components.hunger:DoDelta(food.components.edible:GetHunger(inst)*0.2);
		inst.components.sanity:DoDelta(55);
		inst.components.health:DoDelta((food.components.edible:GetHealth(inst))*0.2, nil, food.prefab);
	end
	if food and food.components.edible and food.prefab == "fishsticks"  then
		inst.components.hunger:DoDelta(food.components.edible:GetHunger(inst)*0.2);
		inst.components.sanity:DoDelta(25);
		inst.components.health:DoDelta((food.components.edible:GetHealth(inst))*0.5, nil, food.prefab);
	end
	if food and food.components.edible and food.prefab == "fishtacos"  then
		inst.components.hunger:DoDelta(food.components.edible:GetHunger(inst)*0.7);
		inst.components.sanity:DoDelta(25);
		inst.components.health:DoDelta((food.components.edible:GetHealth(inst))*0.2, nil, food.prefab);
	end
end

-- This initializes for both clients and the host
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "chillywilly.tex" )
end

-- This initializes for the host only
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "wilson"
	inst:AddTag("fishingmaster")
	
	-- Stats	
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(200)
	inst.components.sanity:SetMax(200)
	inst.components.eater:SetOnEatFn(oneat)
	inst.components.temperature.mintemp = 20
	
end

return MakePlayerCharacter("chillywilly", prefabs, assets, common_postinit, master_postinit, start_inv)
