
local Assets =
{
	Asset("ANIM", "anim/hat_warfarinhood.zip"),
}

local function perish(inst)
        local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
        if owner then
     owner:RemoveTag("notarget")
	end
	inst:Remove()
end

    local function onequip(inst, owner)

        owner.AnimState:OverrideSymbol("swap_hat", "hat_warfarinhood", "swap_hat")
        owner.AnimState:Show("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
    owner:AddTag("notarget")
        if owner:HasTag("player") then
			owner.AnimState:Hide("HEAD")
			owner.AnimState:Hide("HEAD_HAIR")
		end
        
		if inst.components.fueled then
			inst.components.fueled:StartConsuming()        
		end
    end


    local function onunequip(inst, owner)

        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAT_HAIR")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
     owner:RemoveTag("notarget")
		if owner:HasTag("player") then
	        owner.AnimState:Show("HEAD")
			owner.AnimState:Hide("HEAD_HAIR")
		end

		if inst.components.fueled then
			inst.components.fueled:StopConsuming()        
		end

		if inst.components.fueled then
			inst.components.fueled:StopConsuming()        
		end
    end

local function fn(Sim)
        local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank("footballhat")
        inst.AnimState:SetBuild("hat_warfarinhood")
        inst.AnimState:PlayAnimation("anim")
    
    inst:AddTag("sanity")

        inst:AddComponent("inspectable")

  
        inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_warfarinhood.xml"

	inst:AddComponent("insulator")
    inst.components.insulator.insulation = TUNING.INSULATION_MED

        inst:AddComponent("equippable")
        inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable.dapperness = TUNING.CRAZINESS_MED*1.2

        inst:AddComponent("fueled")
        inst.components.fueled.fueltype = "USAGE"
        inst.components.fueled:InitializeFuelLevel(TUNING.TOPHAT_PERISHTIME)
        inst.components.fueled:SetDepletedFn(perish)

        inst.components.equippable:SetOnEquip( onequip )

        inst.components.equippable:SetOnUnequip( onunequip )

        return inst
end


return Prefab( "common/inventory/hat_warfarinhood", fn, Assets)


