
local Assets =
{
	Asset("ANIM", "anim/hat_warfarinmask.zip"),
}

local function breath(inst, target)
    local mindistance = 1
    local caster = inst.components.inventoryitem.owner
    local tar = target or caster
    local pt = tar:GetPosition()

    local blood = SpawnPrefab("warfarin_bleed")
	    local follower = blood.entity:AddFollower()
	    follower:FollowSymbol(tar.GUID, tar.components.combat.hiteffectsymbol, 0, 0, 0 )
        blood:FacePoint(inst.Transform:GetWorldPosition())
	blood.components.combat:SetTarget(tar)

    end

local function perish(inst)
        local owner = inst.components.inventoryitem and inst.components.inventoryitem.owner
        if owner then
     owner:RemoveTag("houndfriend")
	end
	inst:Remove()
end

    local function onequip(inst, owner)

        owner.AnimState:OverrideSymbol("swap_hat", "hat_warfarinmask", "swap_hat")
        owner.AnimState:Show("HAT")
    owner:AddTag("houndfriend")

		if inst.components.fueled then
			inst.components.fueled:StartConsuming()        
		end
    end


    local function onunequip(inst, owner)

        owner.AnimState:Hide("HAT")
     owner:RemoveTag("houndfriend")

		if inst.components.fueled then
			inst.components.fueled:StopConsuming()        
		end
    end

local function fn(Sim)
        local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank("footballhat")
        inst.AnimState:SetBuild("hat_warfarinhood")
        inst.AnimState:PlayAnimation("anim")
    
    inst:AddTag("sanity")

        inst:AddComponent("inspectable")

    inst.fxcolour = {104/255,40/255,121/255} 
    inst:AddComponent("spellcaster")
    inst.components.spellcaster:SetSpellFn(breath)
    inst.components.spellcaster.canuseontargets = true


        inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_warfarinhood.xml"

        inst:AddComponent("equippable")
        inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable.dapperness = TUNING.CRAZINESS_MED


        inst.components.equippable:SetOnEquip( onequip )

        inst.components.equippable:SetOnUnequip( onunequip )

        return inst
end


return Prefab( "common/inventory/hat_warfarinmask", fn, Assets)


