
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/maxwell.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
	Asset("ANIM", "anim/player_mime.zip"),    
		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/warfarin.zip" ),
        Asset( "ANIM", "anim/warfarin_angel.zip" ),
}
local prefabs = 
{
}

local start_inv = 
{
}	

local function CritReset(inst)
if not (inst:HasTag("gotwep")) then
    inst:DoTaskInTime(1, function() 
if not (inst:HasTag("gotwep")) then
    inst:RemoveTag("crit1")
    inst:RemoveTag("crit2")
    inst:RemoveTag("crit3")
    inst:RemoveTag("crit4")
                    SpawnPrefab("statue_transition").Transform:SetPosition(inst:GetPosition():Get())
                    SpawnPrefab("statue_transition_2").Transform:SetPosition(inst:GetPosition():Get())
                    inst.SoundEmitter:PlaySound("dontstarve/maxwell/shadowmax_despawn")
	end
	end)
	end
end	

local fn = function(inst)

	--speech sound and map icon
	inst.soundsname = "webber"
    inst.MiniMapEntity:SetIcon("warfarin.tex")

	inst.AnimState:SetBuild("warfarin")
	--Stats
        inst.components.health:SetMaxHealth(65)
	inst.components.hunger:SetMax(120)
	inst.components.sanity:SetMax(110)
	inst.components.combat.damagemultiplier = 0.80
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED* 1.05)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED* 1.05)
	inst.components.hunger:SetRate(TUNING.WILSON_HUNGER_RATE * 1.1)
	inst.components.sanity.neg_aura_mult = 1.2	
    inst.components.sanity.night_drain_mult = 0.1
	inst.components.talker:IgnoreAll()
	inst.components.combat.attackrange = 2
	inst.components.combat.hitrange = 3
	inst.components.combat.min_attack_period = 0.1
	inst.Transform:SetScale(0.95, 0.95, 0.95)

	local handle = inst.sg.sg.actionhandlers[ACTIONS.HARVEST]
handle.deststate = function(inst) return "doshortaction" end
	local handle = inst.sg.sg.actionhandlers[ACTIONS.PICK]
handle.deststate = function(inst) return "doshortaction" end
	local handle = inst.sg.sg.actionhandlers[ACTIONS.MURDER]
handle.deststate = function(inst) return "doshortaction" end

	inst:DoPeriodicTask(2/10, function()
	if GetClock():IsDusk() then
	local pt = Vector3(inst.Transform:GetWorldPosition())
	local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 3, {"hostile"})
	local fires = TheSim:FindEntities(pt.x,pt.y,pt.z, TUNING.LEIF_REAWAKEN_RADIUS/4, {"fire"})
	local cover = TheSim:FindEntities(pt.x,pt.y,pt.z, 3, {"cover"})
	local tree = TheSim:FindEntities(pt.x,pt.y,pt.z, 3, {"tree"})
	local sneak = TheSim:FindEntities(pt.x,pt.y,pt.z, 2, {"sneak"})
	if #tree > 0 or #sneak > 0 or #cover > 0 then
	if #ents > 0 or #fires > 0 or inst.components.combat.target then
        inst:RemoveTag("shadow")
        inst.AnimState:SetMultColour(1, 1, 1, 1)
	else
        inst:AddTag("shadow")
        inst.AnimState:SetMultColour(0.4, 0.4, 0.4, 0.6)
		end
		else
        inst:RemoveTag("shadow")
        inst.AnimState:SetMultColour(1, 1, 1, 1)
	end
	elseif GetClock():IsNight() then
	local pt = Vector3(inst.Transform:GetWorldPosition())
	local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 1, {"hostile"})
	local fires = TheSim:FindEntities(pt.x,pt.y,pt.z, TUNING.LEIF_REAWAKEN_RADIUS/4, {"fire"})
	local cover = TheSim:FindEntities(pt.x,pt.y,pt.z, 3, {"cover"})
	local tree = TheSim:FindEntities(pt.x,pt.y,pt.z, 4, {"tree"})
	local sneak = TheSim:FindEntities(pt.x,pt.y,pt.z, 2, {"sneak"})
	if #tree > 0 or #sneak > 0 or #cover > 0 then
	if #ents > 0 or #fires > 0 or inst.components.combat.target then
        inst:RemoveTag("shadow")
        inst.AnimState:SetMultColour(1, 1, 1, 1)
	else
        inst:AddTag("shadow")
        inst.AnimState:SetMultColour(0.2, 0.2, 0.2, 0.4)
		end
		else
        inst:RemoveTag("shadow")
        inst.AnimState:SetMultColour(1, 1, 1, 1)
	end
	elseif GetClock():IsDay() then
	local pt = Vector3(inst.Transform:GetWorldPosition())
	local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, 4, {"hostile"})
	local fires = TheSim:FindEntities(pt.x,pt.y,pt.z, TUNING.LEIF_REAWAKEN_RADIUS/5, {"fire"})
	local cover = TheSim:FindEntities(pt.x,pt.y,pt.z, 0.8, {"cover"})
	local tree = TheSim:FindEntities(pt.x,pt.y,pt.z, 1, {"tree"})
	local sneak = TheSim:FindEntities(pt.x,pt.y,pt.z, 0.5, {"sneak"})
	if #tree > 0 or #sneak > 0 or #cover > 0 then
	if #ents > 0 or #fires > 0 or inst.components.combat.target then
        inst:RemoveTag("shadow")
        inst.AnimState:SetMultColour(1, 1, 1, 1)
	else
        inst:AddTag("shadow")
        inst.AnimState:SetMultColour(0.6, 0.6, 0.6, 0.8)
		end
		else
        inst:RemoveTag("shadow")
        inst.AnimState:SetMultColour(1, 1, 1, 1)
	end
	end
end) 

	inst:ListenForEvent("nighttime", function(it, data) 
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.2)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.2)
	end, GetWorld())

	inst:ListenForEvent("dusktime", function(it, data) 
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED * 1.1)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED * 1.1)
	end, GetWorld())

	inst:ListenForEvent("daytime", function(it, data) 
	inst.components.locomotor.walkspeed = (TUNING.WILSON_WALK_SPEED)
	inst.components.locomotor.runspeed = (TUNING.WILSON_RUN_SPEED)
	end , GetWorld())

local warfarinknife = Ingredient( "warfarinknife", 2)
warfarinknife.atlas = "images/inventoryimages/warfarinknife.xml"

local warfarinarrow_normal = Ingredient( "warfarinarrow_normal", 1)
warfarinarrow_normal.atlas = "images/inventoryimages/warfarinarrow_normal.xml"

local warfarinbowarm = Ingredient( "warfarinbowarm", 2)
warfarinbowarm.atlas = "images/inventoryimages/warfarinbowarm.xml"

        local warfarindaggerrecipe = Recipe( ("warfarindagger"), { Ingredient("flint", 1), Ingredient("rope", 1), Ingredient("twigs", 1)}, RECIPETABS.WARFARIN,  {SCIENCE = 1})
      warfarindaggerrecipe.atlas = "images/inventoryimages/warfarindagger.xml"


        local warfarindagger_goldrecipe = Recipe( ("warfarindagger_gold"), { Ingredient("goldnugget", 2), Ingredient("rope", 1), Ingredient("twigs", 2)}, RECIPETABS.WARFARIN,  {SCIENCE = 2})
      warfarindagger_goldrecipe.atlas = "images/inventoryimages/warfarindagger_gold.xml"


        local warfarindagger_marblerecipe = Recipe( ("warfarindagger_marble"), { Ingredient("marble", 4), Ingredient("rope", 1), Ingredient("twigs", 4)}, RECIPETABS.WARFARIN,  {SCIENCE = 2})
      warfarindagger_marblerecipe.atlas = "images/inventoryimages/warfarindagger_marble.xml"

        local warfarindagger_nightrecipe = Recipe( ("warfarindagger_night"), { Ingredient("crow", 2), Ingredient("nightsword", 1), Ingredient("purplegem", 1)}, RECIPETABS.WARFARIN,  {MAGIC = 3})
      warfarindagger_nightrecipe.atlas = "images/inventoryimages/warfarindagger_night.xml"

        local warfarinkniferecipe = Recipe( ("warfarinknife"), { Ingredient("flint", 1), Ingredient("rope", 1), Ingredient("twigs", 4)}, RECIPETABS.WARFARIN,  {SCIENCE = 1}, nil, nil, nil, 2 )
      warfarinkniferecipe.atlas = "images/inventoryimages/warfarinknife.xml"

        local warfarinknifeexrecipe = Recipe( ("warfarinknifeex"), { warfarinknife, Ingredient("gunpowder", 1), Ingredient("papyrus", 2)}, RECIPETABS.WARFARIN,  {SCIENCE = 2}, nil, nil, nil, 2 )
      warfarinknifeexrecipe.atlas = "images/inventoryimages/warfarinknifeex.xml"

        local warfarinarrow_normalrecipe = Recipe( ("warfarinarrow_normal"), { Ingredient("flint", 2), Ingredient("feather_crow", 1), Ingredient("twigs", 1)}, RECIPETABS.WARFARIN,  {SCIENCE = 1})
      warfarinarrow_normalrecipe.atlas = "images/inventoryimages/warfarinarrow_normal.xml"

        local warfarinarrow_rockrecipe = Recipe( ("warfarinarrow_rock"), { Ingredient("rocks", 1), Ingredient("feather_crow", 2), Ingredient("twigs", 2)}, RECIPETABS.WARFARIN,  {SCIENCE = 1}, nil, nil, nil, 2 )
      warfarinarrow_rockrecipe.atlas = "images/inventoryimages/warfarinarrow_rock.xml"

        local warfarinarrow_waterrecipe = Recipe( ("warfarinarrow_water"), { Ingredient("ice", 1), Ingredient("feather_robin_winter", 1), Ingredient("twigs", 1)}, RECIPETABS.WARFARIN,  {SCIENCE = 2} )
      warfarinarrow_waterrecipe.atlas = "images/inventoryimages/warfarinarrow_water.xml"

        local warfarinarrow_firerecipe = Recipe( ("warfarinarrow_fire"), { Ingredient("gunpowder", 1), Ingredient("feather_robin", 1), Ingredient("twigs", 1)}, RECIPETABS.WARFARIN,  {SCIENCE = 2})
      warfarinarrow_firerecipe.atlas = "images/inventoryimages/warfarinarrow_fire.xml"

        local warfarinarrow_spikerecipe = Recipe( ("warfarinarrow_spike"), { warfarinarrow_normal, Ingredient("houndstooth", 2), Ingredient("stinger", 2)}, RECIPETABS.WARFARIN,  {SCIENCE = 1})
      warfarinarrow_spikerecipe.atlas = "images/inventoryimages/warfarinarrow_spike.xml"

        local warfarinbowarmrecipe = Recipe( ("warfarinbowarm"), { Ingredient("cutstone", 6), Ingredient("goldnugget", 2), Ingredient("marble", 2)}, RECIPETABS.WARFARIN,  {SCIENCE = 2})
      warfarinbowarmrecipe.atlas = "images/inventoryimages/warfarinbowarm.xml"

        local warfarinbowrecipe = Recipe( ("warfarinbow"), { warfarinbowarm, Ingredient("rope", 6), Ingredient("boards", 1)}, RECIPETABS.WARFARIN,  {SCIENCE = 2})
      warfarinbowrecipe.atlas = "images/inventoryimages/warfarinbow.xml"

        local hat_warfarinhoodrecipe = Recipe( ("hat_warfarinhood"), { Ingredient("trunk_summer", 1), Ingredient("beefalowool", 4), Ingredient("petals_evil", 16)}, RECIPETABS.WARFARIN,  {MAGIC = 2})
      hat_warfarinhoodrecipe.atlas = "images/inventoryimages/hat_warfarinhood.xml"

end

-- strings! Any "WOD" below would have to be replaced by the prefab name of your character.

-- First up, the character select screen lines 
-- note: these are lower-case character name
STRINGS.CHARACTER_TITLES.warfarin = "  צ    ƿ"
STRINGS.CHARACTER_NAMES.warfarin = "  "
STRINGS.CHARACTER_DESCRIPTIONS.warfarin = "*   ʦ \n*  , û        \n*       "
STRINGS.CHARACTER_QUOTES.warfarin = "\"...! \""
return MakePlayerCharacter("warfarin", prefabs, assets, fn , start_inv)