local assets =
{
	Asset("ANIM", "anim/warfarinbow_arrow.zip"),
	Asset("ANIM", "anim/warfarinbow_arrow2.zip"),
}

local function OnIgniteFn(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/blackpowder_fuse_LP", "hiss")
end

local function OnExplodeFn(inst)
    local pos = Vector3(inst.Transform:GetWorldPosition())
    inst.SoundEmitter:KillSound("hiss")
    inst.SoundEmitter:PlaySound("dontstarve/common/blackpowder_explo")

    local explode = SpawnPrefab("explode_small")
    local pos = inst:GetPosition()
    explode.Transform:SetPosition(pos.x, pos.y, pos.z)

    --local explode = PlayFX(pos,"explode", "explode", "small")
    explode.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
    explode.AnimState:SetLightOverride(1)
end


local function commonfn()
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	local sound = inst.entity:AddSoundEmitter()
	local light = inst.entity:AddLight()

    anim:SetBank("nightmare_watch")
    anim:SetBuild("warfarinbow_arrow")
    anim:PlayAnimation("idle_1")
	inst.Transform:SetScale(0, 0, 0)
    
	inst.persists = false

    inst:AddTag("FX")
    inst:AddTag("NOCLICK")

    anim:SetFinalOffset(1)
    return inst
end

local function splode()
	local inst = commonfn()

	MakeSmallBurnable(inst, 1+math.random()*1)
    MakeSmallPropagator(inst)

    inst:AddComponent("explosive")
    inst.components.explosive:SetOnExplodeFn(OnExplodeFn)
    inst.components.explosive:SetOnIgniteFn(OnIgniteFn)
    inst.components.explosive.explosivedamage = 225
	return inst
end

local function KeepTarget(isnt, target)
    return true
end

local function blood()
	local inst = commonfn()


    inst.AnimState:SetBank("splash")
    inst.AnimState:SetBuild("splash")
    inst.AnimState:PlayAnimation("splash")
    inst.AnimState:SetMultColour(1,0,0,1)
	inst.Transform:SetScale(1, 1, 1)

        inst:ListenForEvent("animover", function() inst:Remove() end)

	return inst
end

local function bleed()
	local inst = commonfn()

    inst:AddTag("shadow")
    inst:AddTag("notarget")
    inst:AddTag("notraptrigger")

    inst:AddComponent("combat")
    inst.components.combat:SetKeepTargetFunction(KeepTarget)
    inst.components.combat:SetAttackPeriod(1000)

    inst.components.combat:SetDefaultDamage(5)
    inst.components.combat.canbeattackedfn = function() return false end
    inst:AddComponent("health")
    inst.components.health:SetMaxHealth(400)

    inst:SetStateGraph("SGshadowtentacle")

    inst:DoTaskInTime(2, function() inst.components.combat:DoAttack() 
   SpawnPrefab("warfarin_blood").Transform:SetPosition(inst:GetPosition():Get())
	end)

    inst:DoTaskInTime(4, function() inst.components.combat:DoAttack() 
   SpawnPrefab("warfarin_blood").Transform:SetPosition(inst:GetPosition():Get())
	end)

    inst:DoTaskInTime(6, function() inst.components.combat:DoAttack() 
   SpawnPrefab("warfarin_blood").Transform:SetPosition(inst:GetPosition():Get())
	end)

    inst:DoTaskInTime(8, function() inst.components.combat:DoAttack() 
   SpawnPrefab("warfarin_blood").Transform:SetPosition(inst:GetPosition():Get())
	end)

    inst:DoTaskInTime(10, function() inst.components.combat:DoAttack() 
   SpawnPrefab("warfarin_blood").Transform:SetPosition(inst:GetPosition():Get())
	end)

    inst:DoTaskInTime(12, function() inst:Remove() end)
	return inst
end

return Prefab( "common/fx/warfarinsplode", splode, assets),
	Prefab( "common/fx/warfarin_blood", blood, assets),
	Prefab( "common/fx/warfarin_bleed", bleed, assets)
