local assets=
{
	Asset("ANIM", "anim/warfarin_arrows1.zip"),
	Asset("ANIM", "anim/warfarin_arrows2.zip"),
	Asset("ANIM", "anim/swap_warfarin_bow.zip"),
}
    
local prefabs =
{
}

local survivechance = 0.2
local function OnFinished(inst)
    inst.AnimState:PlayAnimation("used")
    inst:ListenForEvent("animover", function() inst:Remove() end)
end

local function OnEquip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarin_bow", "swap_spear")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
    inst.string = SpawnPrefab( "warfarinbowstring_normal" )
    local follower = inst.string.entity:AddFollower()
    follower:FollowSymbol( owner.GUID, "swap_object", 0, -10, -0.1 )
end

local function OnDropped(inst)
    inst.AnimState:PlayAnimation("idle_pipe")
end

local function OnUnequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
	inst.string:Remove()
    inst.string = nil
end

local function OnThrown(inst, owner, target)
    if target ~= owner then
        owner.SoundEmitter:PlaySound("dontstarve/creatures/monkey/throw")
    end
    inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
    inst.AnimState:PlayAnimation("dart_pipe")
	inst.Transform:SetScale(1.4, 1.4, 1.4)
end

local function OnHit(inst, owner, target)
        OnDropped(inst)
    local impactfx = SpawnPrefab("impact")
    if impactfx then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(inst.Transform:GetWorldPosition())
    end
   if math.random() < survivechance then
    local knife = SpawnPrefab("warfarinarrow_normal")
	    local follower = knife.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        knife:FacePoint(inst.Transform:GetWorldPosition())
    knife.AnimState:PlayAnimation("dart_pipe")
	end
	inst:Remove()
end


local function commonfn()
	local inst = CreateEntity()
	local trans = inst .entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    
    inst:AddTag("bow")


    return inst
end

local function normal()
	local inst = commonfn()
    RemovePhysicsColliders(inst)
    
    inst.AnimState:SetBank("blow_dart")
    inst.AnimState:SetBuild("warfarin_arrows1")
    inst.AnimState:PlayAnimation("idle_pipe")
    inst.AnimState:SetRayTestOnBB(true);
    
	inst.Transform:SetScale(1.2, 1.2, 1.2)


    inst:AddTag("normbow")
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetRange(TUNING.BOOMERANG_DISTANCE+1.5, TUNING.BOOMERANG_DISTANCE+2)
    -------

    inst:AddComponent("inspectable")
    
    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(47)
    inst.components.projectile:SetOnThrownFn(OnThrown)
    inst.components.projectile:SetOnHitFn(OnHit)
    
    inst:AddComponent("stackable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarinarrow_normal.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
    inst.components.equippable.equipstack = true

    inst.components.weapon:SetDamage(78)

	inst:DoPeriodicTask(1/100, function()
	if inst.components.equippable.isequipped then
    if not GetPlayer().components.inventory:Has("warfarinbow", 1) then
    inst:DoTaskInTime(0.5, function() GetPlayer().components.inventory:DropItem(inst)
		end) 
	end
end
end) 

	return inst
end

----------------------------------------------------------------------

local function OnEquiprock(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarin_bow", "swap_spear")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
    inst.string = SpawnPrefab( "warfarinbowstring_rock" )
    local follower = inst.string.entity:AddFollower()
    follower:FollowSymbol( owner.GUID, "swap_object", 0, -10, -0.1 )
        inst.string:FacePoint(inst.Transform:GetWorldPosition())
end

local function OnDroppedrock(inst)
    inst.AnimState:PlayAnimation("idle_purple")
end

local function OnUnequiprock(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
	inst.string:Remove()
    inst.string = nil
end

local function OnThrownrock(inst, owner, target)
    if target ~= owner then
        owner.SoundEmitter:PlaySound("dontstarve/creatures/monkey/throw")
    end
    inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
    inst.AnimState:PlayAnimation("dart_purple")
	inst.Transform:SetScale(1.4, 1.4, 1.4)
end

local function OnHitrock(inst, owner, target)
        OnDropped(inst)
    local impactfx = SpawnPrefab("impact")
    if impactfx then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(inst.Transform:GetWorldPosition())
    end
    if target:HasTag("wall") then
	local pt = Vector3(inst.Transform:GetWorldPosition())
	local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, TUNING.LEIF_REAWAKEN_RADIUS, {"monster"})
	for k,v in pairs(ents) do

		v.components.combat:SuggestTarget(target)
	end
	local pt = Vector3(inst.Transform:GetWorldPosition())
	local ents = TheSim:FindEntities(pt.x,pt.y,pt.z, TUNING.LEIF_REAWAKEN_RADIUS, {"wallerhit"})
	for k,v in pairs(ents) do

		v.components.combat:SuggestTarget(target)
	end
	end
    if target:HasTag("haywall") then
        inst.SoundEmitter:PlaySound("dontstarve/common/destroy_straw")
    elseif target:HasTag("woodwall") then
        inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
    elseif target:HasTag("stonewall") then
        inst.SoundEmitter:PlaySound("dontstarve/common/destroy_stone")
    elseif target:HasTag("ruinswall") then
        inst.SoundEmitter:PlaySound("dontstarve/common/destroy_metal")
	end
	inst:Remove()
end



local function rock()
	local inst = commonfn()
    RemovePhysicsColliders(inst)
    
    inst.AnimState:SetBank("blow_dart")
    inst.AnimState:SetBuild("warfarin_arrows1")
    inst.AnimState:PlayAnimation("idle_purple")
    inst.AnimState:SetRayTestOnBB(true);
    
	inst.Transform:SetScale(1.2, 1.2, 1.2)

    inst:AddTag("rockbow")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetRange(TUNING.BOOMERANG_DISTANCE+1.5, TUNING.BOOMERANG_DISTANCE+2)
    -------

    inst:AddComponent("inspectable")
    
    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(30)
    inst.components.projectile:SetOnThrownFn(OnThrownrock)
    inst.components.projectile:SetOnHitFn(OnHitrock)
    
    inst:AddComponent("stackable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarinarrow_rock.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDroppedrock)
    

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(OnEquiprock)
    inst.components.equippable:SetOnUnequip(OnUnequiprock)
    inst.components.equippable.equipstack = true

    inst.components.weapon:SetDamage(28)

	inst:DoPeriodicTask(1/100, function()
	if inst.components.equippable.isequipped then
    if not GetPlayer().components.inventory:Has("warfarinbow", 1) then
    inst:DoTaskInTime(0.5, function() GetPlayer().components.inventory:DropItem(inst)
		end) 
	end
end
end) 

	return inst
end

-------------------------------------------------------

local function OnEquipwater(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarin_bow", "swap_spear")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
    inst.string = SpawnPrefab( "warfarinbowstring_water" )
    local follower = inst.string.entity:AddFollower()
    follower:FollowSymbol( owner.GUID, "swap_object", 0, -10, -0.1 )
        inst.string:FacePoint(inst.Transform:GetWorldPosition())
end


local function OnUnequipwater(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
	inst.string:Remove()
    inst.string = nil
end

local function OnDroppedwater(inst)
    inst.AnimState:PlayAnimation("idle_red")
end

local function OnThrownwater(inst, owner, target)
    if target ~= owner then
        owner.SoundEmitter:PlaySound("dontstarve/creatures/monkey/throw")
    end
    inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
    inst.AnimState:PlayAnimation("dart_red")
	inst.Transform:SetScale(1.4, 1.4, 1.4)
end

local function OnHitwater(inst, owner, target)
        OnDropped(inst)
    if target.components.burnable then
        if target.components.burnable:IsBurning() then
            target.components.burnable:Extinguish()
        elseif target.components.burnable:IsSmoldering() then
            target.components.burnable:SmotherSmolder()
        end
    end
	if target.components.combat then
    local impactfx = SpawnPrefab("splash_ocean")
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(inst.Transform:GetWorldPosition())
else
                    SpawnPrefab("splash_ocean").Transform:SetPosition(inst:GetPosition():Get())
	end
	inst:Remove()
end

local function water()
	local inst = commonfn()

    inst:AddTag("extinguisher")

    RemovePhysicsColliders(inst)
    
    inst.AnimState:SetBank("blow_dart")
    inst.AnimState:SetBuild("warfarin_arrows1")
     inst.AnimState:PlayAnimation("idle_red")
    inst.AnimState:SetRayTestOnBB(true);
    
	inst.Transform:SetScale(1.2, 1.2, 1.2)


    inst:AddTag("waterbow")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetRange(TUNING.BOOMERANG_DISTANCE+1.5, TUNING.BOOMERANG_DISTANCE+2)
    -------

    inst:AddComponent("inspectable")
    
    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(30)
    
    inst:AddComponent("stackable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarinarrow_water.xml"
    


    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(OnEquipwater)
    inst.components.equippable:SetOnUnequip(OnUnequipwater)
    inst.components.equippable.equipstack = true

    inst.components.weapon:SetDamage(18)

    inst.components.projectile:SetOnThrownFn(OnThrownwater)
    inst.components.projectile:SetOnHitFn(OnHitwater)

    inst.components.inventoryitem:SetOnDroppedFn(OnDroppedwater)

	inst:DoPeriodicTask(1/100, function()
	if inst.components.equippable.isequipped then
    if not GetPlayer().components.inventory:Has("warfarinbow", 1) then
    inst:DoTaskInTime(0.5, function() GetPlayer().components.inventory:DropItem(inst)
		end) 
	end
end
end) 

	return inst
end

-------------------------------------------------

local function OnEquipex(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarin_bow", "swap_spear")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
    inst.string = SpawnPrefab( "warfarinbowstring_fire" )
    local follower = inst.string.entity:AddFollower()
    follower:FollowSymbol( owner.GUID, "swap_object", 0, -10, -0.1 )
end

local function OnDroppedex(inst)
    inst.AnimState:PlayAnimation("idle_red")
end

local function OnUnequipex(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
	inst.string:Remove()
    inst.string = nil
end

local function OnThrownex(inst, owner, target)
    if target ~= owner then
        owner.SoundEmitter:PlaySound("dontstarve/creatures/monkey/throw")
    end
    inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
    inst.AnimState:PlayAnimation("dart_red")
	inst.Transform:SetScale(1.4, 1.4, 1.4)
end

local function OnHitex(inst, owner, target)
        OnDropped(inst)
    local impactfx = SpawnPrefab("warfarinsplode")
    if impactfx then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(inst.Transform:GetWorldPosition())
    if target.components.burnable then   
            target.components.burnable:Ignite(true)
	end
    end
	inst:Remove()
end

local function explo()
	local inst = commonfn()
    RemovePhysicsColliders(inst)
    
    inst.AnimState:SetBank("blow_dart")
    inst.AnimState:SetBuild("warfarin_arrows2")
    inst.AnimState:PlayAnimation("idle_red")
    inst.AnimState:SetRayTestOnBB(true);
    
	inst.Transform:SetScale(1.2, 1.2, 1.2)

    inst:AddTag("rangedfireweapon")
    inst:AddTag("normbow")
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetRange(TUNING.BOOMERANG_DISTANCE+1.5, TUNING.BOOMERANG_DISTANCE+2)
    -------
    inst:AddTag("firestaff")
    inst:AddComponent("lighter")

    inst:AddComponent("inspectable")
    
    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(30)
    inst.components.projectile:SetOnThrownFn(OnThrownex)
    inst.components.projectile:SetOnHitFn(OnHitex)
    
    inst:AddComponent("stackable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarinarrow_fire.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDroppedex)
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(OnEquipex)
    inst.components.equippable:SetOnUnequip(OnUnequipex)
    inst.components.equippable.equipstack = true

    inst.components.weapon:SetDamage(20)

	inst:DoPeriodicTask(1/100, function()
	if inst.components.equippable.isequipped then
    if not GetPlayer().components.inventory:Has("warfarinbow", 1) then
    inst:DoTaskInTime(0.5, function() GetPlayer().components.inventory:DropItem(inst)
		end) 
	end
end
end) 

	return inst
end

------------------------

local function OnEquipspike(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarin_bow", "swap_spear")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
    inst.string = SpawnPrefab( "warfarinbowstring_spike" )
    local follower = inst.string.entity:AddFollower()
    follower:FollowSymbol( owner.GUID, "swap_object", 0, -10, -0.1 )
end

local function OnDroppedspike(inst)
    inst.AnimState:PlayAnimation("idle_pipe")
end

local function OnUnequipspike(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
	inst.string:Remove()
    inst.string = nil
end

local function OnThrownspike(inst, owner, target)
    if target ~= owner then
        owner.SoundEmitter:PlaySound("dontstarve/creatures/monkey/throw")
    end
    inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
    inst.AnimState:PlayAnimation("dart_pipe")
	inst.Transform:SetScale(1.4, 1.4, 1.4)
end

local function OnHitspike(inst, owner, target)
        OnDropped(inst)
    local impactfx = SpawnPrefab("impact")
    if impactfx then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(inst.Transform:GetWorldPosition())
    end
    local blood = SpawnPrefab("warfarin_bleed")
	    local follower = blood.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        blood:FacePoint(inst.Transform:GetWorldPosition())
	blood.components.combat:SetTarget(target)
	inst:Remove()
end

local function sharp()
	local inst = commonfn()
    RemovePhysicsColliders(inst)
    
    inst.AnimState:SetBank("blow_dart")
    inst.AnimState:SetBuild("warfarin_arrows2")
    inst.AnimState:PlayAnimation("idle_pipe")
    inst.AnimState:SetRayTestOnBB(true);
    
	inst.Transform:SetScale(1.2, 1.2, 1.2)

    inst:AddTag("normbow")
    inst:AddTag("sharp")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetRange(TUNING.BOOMERANG_DISTANCE+1.5, TUNING.BOOMERANG_DISTANCE+2)
    -------

    inst:AddComponent("inspectable")
    
    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(30)
    inst.components.projectile:SetOnThrownFn(OnThrownspike)
    inst.components.projectile:SetOnHitFn(OnHitspike)
    
    inst:AddComponent("stackable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarinarrow_spike.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDroppedspike)
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(OnEquipspike)
    inst.components.equippable:SetOnUnequip(OnUnequipspike)
    inst.components.equippable.equipstack = true

    inst.components.weapon:SetDamage(98)

	inst:DoPeriodicTask(1/100, function()
	if inst.components.equippable.isequipped then
    if not GetPlayer().components.inventory:Has("warfarinbow", 1) then
    inst:DoTaskInTime(0.5, function() GetPlayer().components.inventory:DropItem(inst)
		end) 
	end
end
end) 

	return inst
end

return Prefab( "common/inventory/warfarinarrow_normal", normal, assets), 
	Prefab( "common/inventory/warfarinarrow_rock", rock, assets),
	Prefab( "common/inventory/warfarinarrow_fire", explo, assets),
	Prefab( "common/inventory/warfarinarrow_spike", sharp, assets),
	Prefab( "common/inventory/warfarinarrow_water", water, assets)  
