local assets=
{
	Asset("ANIM", "anim/warfarindagger.zip"),
	Asset("ANIM", "anim/warfarindaggergold.zip"),
	Asset("ANIM", "anim/warfarindaggermarble.zip"),
	Asset("ANIM", "anim/warfarindaggernight.zip"),
	Asset("ANIM", "anim/swap_warfarindagger.zip"),
	Asset("ANIM", "anim/swap_warfarindaggergold.zip"),
	Asset("ANIM", "anim/swap_warfarindaggermarble.zip"),
	Asset("ANIM", "anim/swap_warfarindaggernight.zip"),
}

local function onfinished(inst)
    inst:Remove()
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarindagger", "swap_spear")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end


local function fn(Sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    MakeInventoryPhysics(inst)
    
    anim:SetBank("nightmaresword")
    anim:SetBuild("warfarindagger")
    anim:PlayAnimation("idle")
    
    inst:AddTag("sharp")
    inst:AddTag("lildagger")

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(23)
    
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(175)
    inst.components.finiteuses:SetUses(175)
    
    inst.components.finiteuses:SetOnFinished( onfinished )

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarindagger.xml"    

    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    
    return inst
end

local function onequipgold(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarindaggergold", "swap_spear")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")     
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function golden(Sim)
	local inst = fn(Sim)
	inst.AnimState:SetBuild("warfarindaggergold")
    inst.components.weapon:SetDamage(37)
        inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarindagger_gold.xml"
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(250)
    inst.components.finiteuses:SetUses(250)
   inst.components.finiteuses:SetOnFinished( onfinished )
    inst.components.equippable:SetOnEquip( onequipgold )
    
	return inst
end

local function onequipmarble(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarindaggermarble", "swap_cane")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")     
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function marble(Sim)
	local inst = fn(Sim)
	inst.AnimState:SetBuild("warfarindaggermarble")
    inst.components.weapon:SetDamage(48)
        inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarindagger_marble.xml"
    -------
    
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(345)
    inst.components.finiteuses:SetUses(345)
   inst.components.finiteuses:SetOnFinished( onfinished )
    inst.components.equippable:SetOnEquip( onequipmarble )
    
	return inst
end

local function onequipnight(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarindaggernight", "swap_cane")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")     
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function night(Sim)
	local inst = fn(Sim)
	inst.AnimState:SetBuild("warfarindaggernight")
    inst.components.weapon:SetDamage(57)
        inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarindagger_night.xml"
    -------
    inst:AddTag("shadow")    

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(120)
    inst.components.finiteuses:SetUses(120)
   inst.components.finiteuses:SetOnFinished( onfinished )
    inst.components.equippable:SetOnEquip( onequipnight )
    
	return inst
end

return Prefab( "common/inventory/warfarindagger", fn, assets),
	Prefab( "common/inventory/warfarindagger_marble", marble, assets),
	Prefab( "common/inventory/warfarindagger_night", night, assets),
	Prefab( "common/inventory/warfarindagger_gold", golden, assets) 
