local assets=
{
	Asset("ANIM", "anim/warfarin_knife.zip"),
	Asset("ANIM", "anim/swap_blowdart.zip"),
	Asset("ANIM", "anim/swap_warfarin_bow.zip"),
}
    
local prefabs =
{
}

local survivechance = 0.1

local function OnFinished(inst)
    inst.AnimState:PlayAnimation("used")
    inst:ListenForEvent("animover", function() inst:Remove() end)
end

local function OnEquip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_warfarin_bow", "swap_blowdart")
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal")
end

local function OnDropped(inst)
    inst.AnimState:PlayAnimation("idle_pipe")
end

local function OnUnequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function OnThrown(inst, owner, target)
    if target ~= owner then
        owner.SoundEmitter:PlaySound("dontstarve/creatures/monkey/throw")
    end
    inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
    inst.AnimState:PlayAnimation("dart_pipe")
	inst.Transform:SetScale(1.4, 1.4, 1.4)
end

local function OnHit(inst, owner, target)
        OnDropped(inst)
    local impactfx = SpawnPrefab("impact")
    if impactfx then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(inst.Transform:GetWorldPosition())
    end
   if math.random() < survivechance then
    local knife = SpawnPrefab("warfarinknife")
	    local follower = knife.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        knife:FacePoint(inst.Transform:GetWorldPosition())
    knife.AnimState:PlayAnimation("dart_pipe")
	end
	inst:Remove()
end

local function OnDroppedex(inst)
    inst.AnimState:PlayAnimation("idle_red")
end

local function OnThrownex(inst, owner, target)
    if target ~= owner then
        owner.SoundEmitter:PlaySound("dontstarve/creatures/monkey/throw")
    end
    inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
    inst.AnimState:PlayAnimation("dart_red")
	inst.Transform:SetScale(1.4, 1.4, 1.4)
end

local function OnHitex(inst, owner, target)
        OnDropped(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/blackpowder_explo")
    local impactfx = SpawnPrefab("explode_small")
    if impactfx then
	    local follower = impactfx.entity:AddFollower()
	    follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0 )
        impactfx:FacePoint(inst.Transform:GetWorldPosition())
    --local impactfx = PlayFX(pos,"explode", "explode", "small")
    impactfx.AnimState:SetBloomEffectHandle( "shaders/anim.ksh" )
    impactfx.AnimState:SetLightOverride(1)
    if target.components.burnable then   
            target.components.burnable:Ignite(true)
	end
    end
	inst:Remove()
end

local function commonfn()
	local inst = CreateEntity()
	local trans = inst .entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
    RemovePhysicsColliders(inst)
    
    anim:SetBank("blow_dart")
    anim:SetBuild("warfarin_knife")
    anim:PlayAnimation("idle_pipe")
    anim:SetRayTestOnBB(true);
    
	inst.Transform:SetScale(1.6, 1.6, 1.6)

    inst:AddTag("projectile")
    inst:AddTag("thrown")
    
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(25)
    inst.components.weapon:SetRange(TUNING.BOOMERANG_DISTANCE, TUNING.BOOMERANG_DISTANCE+2)
    -------

    inst:AddComponent("inspectable")
    
    inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(25)
    inst.components.projectile:SetOnThrownFn(OnThrown)
    inst.components.projectile:SetOnHitFn(OnHit)
    
    inst:AddComponent("stackable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarinknife.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDropped)
    
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
    inst.components.equippable.equipstack = true
    
    return inst
end

local function normal()
	local inst = commonfn()
	return inst
end

local function explo()
	local inst = commonfn()

    inst.components.weapon:SetDamage(100)

    inst.components.projectile:SetOnThrownFn(OnThrownex)
    inst.components.projectile:SetOnHitFn(OnHitex)

    inst.components.inventoryitem.atlasname = "images/inventoryimages/warfarinknifeex.xml"
    inst.components.inventoryitem:SetOnDroppedFn(OnDroppedex)
	return inst
end

return Prefab( "common/inventory/warfarinknife", normal, assets),
	Prefab( "common/inventory/warfarinknifeex", explo, assets)  
