local onitemgetfn = function(inst, data)
    local pageable = inst.components.pageable
    if pageable and data and data.item and data.slot then
        --print("onitemgetfn")
        --print(data.item, data.slot)
        pageable:PageToItem(data.slot)
    end
end
local Pageable = Class(function ( self, inst)
    self.inst = inst
    self.container = inst.replica.container or nil
    self.pagecount = 1
    self.inst.ispaging = false
    self.LisenerList = {}

    --if not TheWorld.ismastersim then
        inst:DoTaskInTime(.3, function(inst, thefn)
            inst:ListenForEvent("itemget", thefn)
        end, onitemgetfn)
    --end

end)

function Pageable:SetPagecount(pagecount)
    if pagecount == nil then pagecount = 0 end
    self.pagecount = pagecount>1 and pagecount or self.pagecount
end

function Pageable:SetSlotsTrue(slotstrue)
    if not self.slotstrue then
        self.slotstrue = slotstrue
    end
end

function Pageable:GetContainer()
    return self.container
end

function Pageable:IsListening(source, event)
    for k,v in pairs(self.inst.event_listening[event] or {}) do
        if k == source then
            return true
        end
    end
    return false
end

function Pageable:OnUpdate(dt)
    if TheWorld.ismastersim then
        self.inst.pagecount:set_local(self.pagecount)
        self.inst.pagecount:set(self.pagecount)
        if self.can_update_other_netvar then
            self.inst.net_ispaging:set_local(self.inst.ispaging)
            self.inst.net_ispaging:set(self.inst.ispaging)
        end
    else
        --self.inst:StopUpdatingComponent(self)
        
    end
    if not (ThePlayer and ThePlayer.HUD) then return end
    local theclassified = self.container.classified
        if not theclassified then  return end
        for k,v in pairs(theclassified._items) do
            if v:value() then
                if not self:IsListening(v:value(), "stacksizechange") then
                    self.inst:ListenForEvent("stacksizechange", function(inst, data)
                        --print("onstacksizechange", inst)
                        for k,v in pairs(inst.event_listeners["stacksizechange"] or {}) do
                            if k and k.components and k.components.pageable and k ~= inst then
                                k.components.pageable:PageToItem(inst)
                            end
                        end
                    end, v:value())
                end
            end
        end
end

function Pageable:Refresh()
    if ThePlayer and ThePlayer.HUD and ThePlayer.HUD.controls and ThePlayer.HUD.controls.containers[self.inst] and ThePlayer.HUD.controls.containers[self.inst].container and ThePlayer.HUD.controls.containers[self.inst].container.replica.container then
            ThePlayer.HUD.controls.containers[self.inst]:Refresh()
    end
    --anim and sounds--
    if self.pagewidget and self.inst.components.container and self.inst.components.container:IsOpen() then
        self.pagewidget:GetParent().bganim:GetAnimState():PlayAnimation("open")
        local soundEnitter = nil
        if self.inst and self.inst.SoundEmitter then
            soundEnitter = self.inst.SoundEmitter
        end
        if self.inst.replica.container.issidewidget then
            if soundEnitter then
                soundEnitter:PlaySound("dontstarve/wilson/backpack_open")
            end
        else
            if soundEnitter then
                soundEnitter:PlaySound("dontstarve/wilson/chest_open")
            end
        end
    end
end

function Pageable:RefreshContainer(pagecount)
    if pagecount <= self.pagecount then return end
    self:SetPagecount(pagecount)
    local theclassified = self.container.classified
    if not theclassified then print("theclassified nil") return end
    self:SetSlotsTrue(self.container._numslots)
    theclassified:InitializeSlots(self.container._numslots, true)
    local cmp = self.inst.components.container
    if cmp then
        self.inst:StartUpdatingComponent(self)
        self:SetSlotsTrue(cmp.numslots)
        cmp:SetNumSlots(self.pagecount * self.slotstrue)
    end
    if not TheWorld.ismastersim then
        --theclassified:RemoveAllEventCallbacks()
        theclassified:DoTaskInTime(0, theclassified:MyRegisterNetListeners(self.slotstrue))
        self.inst:StartUpdatingComponent(self)
    end

end

function Pageable:SetIsPaging(ispaging)
    self.inst.ispaging = ispaging
    --print("set",ispaging)
    
end
function Pageable:GetIsPaging()
    return self.inst.ispaging
end

function Pageable:FindSlotOfItem(itemtofind)
    local theclassified = self.container.classified
    if not theclassified then print("theclassified nil") return 0 end
    for k,v in pairs(theclassified._items) do
        local item = v:value()
        if item == itemtofind then
            return k
        end
    end
    return 0
end

-----
function Pageable:Move(count, prev)
    if count == nil or count == 0 then return end
    self.can_update_other_netvar = true
    if self:GetIsPaging() then return else self:SetIsPaging(true) end
    
    local theclassified = self.container.classified
    local thecontainer = self.inst.components.container
    if not (theclassified and thecontainer) then return end

    local items = {}
    local _items = theclassified._items
    --copy _items--
    for k,v in ipairs(_items) do
        table.insert(items, v)
    end

    local tempslots = {}
    --copy numslots--
    for i = 1, thecontainer.numslots do
        tempslots[i] = {true}
        tempslots[i][2] = thecontainer.slots[i]
    end
    --move to prev
    if  prev then
        for i = 1, count do
            table.insert(items, 1, table.remove(items))
        end
        for i = 1, count do
            table.insert(tempslots, 1, table.remove(tempslots))
        end
    else -- move to next
        for i = 1, count do
            table.insert(items, table.remove(items, 1))
        end
        for i = 1, count do
            table.insert(tempslots, table.remove(tempslots, 1))
        end
    end
    --get values of netitem--
    local itemvalues = {}
    for k,v in ipairs(items) do
        itemvalues[k] = v:value()
    end
    --reset the values--
    for k,v in ipairs(_items) do
        v:set_local(itemvalues[k])
        v:set(itemvalues[k])
    end
    for i = 1, thecontainer.numslots do
        thecontainer.slots[i] = tempslots[i][2]
    end
    --Refresh--
    self:Refresh()
    -----
    self.inst:DoTaskInTime(.15, function(inst, pageable)
        --print("SetIspaging(false)")
        --print("net_ispaging",pageable.inst.net_ispaging)
        pageable:SetIsPaging(false)
    end, self)
end
function Pageable:Page(page, prev)
    if page == nil or page <= 0 then return end
    if not TheWorld.ismastersim then self:CallPage(page, prev) return end
    self:Move(page * self.slotstrue, prev)
end
-----
function Pageable:PageToItem(itemslot)
    --print(itemslot)
    local slot = 0
    if type(itemslot) == "number" then
        slot = itemslot
    end
    if type(itemslot) == "table" then
        if itemslot.components and itemslot.replica.inventoryitem then
            slot = self:FindSlotOfItem(itemslot)
            --print("slot", slot)
        end
    end
    local movepage = math.floor(slot/(self.slotstrue+0.1))
    --print("movepage", movepage)
    if movepage < math.ceil(self.pagecount/2) then
        self:Page(movepage)
    else
        self:Page(self.pagecount - movepage, true)
    end
end

function Pageable:ListItems()
    local theclassified = self.container.classified
    for k,v in pairs(theclassified._items) do
        print(k, v, v:value())
    end
end

function Pageable:List(t,name)
    print(name)
    for i,v in ipairs(t) do
        print(i,v,v:value())
    end
end

function Pageable:CallPage(count, prev)
    if TheWorld.ismastersim then return end
    if self:GetIsPaging() then return else self:SetIsPaging(true) end
    PCT.SendRPC("page", self.inst, "page", count, prev)
    if self.pagewidget and self.container._isopen then
        self.pagewidget:GetParent().bganim:GetAnimState():PlayAnimation("open")
        if self.inst.replica.container.issidewidget then
            --clear src_pos--
            local theclassified = self.container.classified
            if theclassified then
                for k,v in ipairs(theclassified._items) do
                    local item = v:value()
                    if item and item.replica.inventoryitem and item.replica.inventoryitem.classified then
                            item.replica.inventoryitem.classified.src_pos.isvalid:set(false)
                    end
                end
            end
            --  ---
            --self.inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")
        else
            self.inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")
        end
    end 
end

function Pageable:CallMove(count, prev)
    if TheWorld.ismastersim then return end
    if self:GetIsPaging() then return else self:SetIsPaging(true) end
    PCT.SendRPC("page", self.inst, "move", count, prev)

end
function Pageable:SortItemByName()
    -- body
end
function Pageable:SortItemByType(typewant)
    
end
function Pageable:SortItem( ... )
    -- body
end













































return Pageable