local PageWidget = require("widgets/pagewidget")
local containers = require("containers")
local assets =
{
    Asset("ANIM", "anim/pct_transformer.zip"),
}

local function IsAllowType(container)
    for k,v in ipairs(PCT.allowtypes) do
        if container.type == v then
            return true
        end
    end
    return false
end

local onputininv = function(inst, owner)
    local container = inst.components.inventoryitem:GetContainer()
    
    if container == owner.components.inventory then return end -- check is Inventory
    if not IsAllowType(container) then return end -- check is allow type
    
    if container.inst.components.pageable == nil then
        if container.numslots * inst.multi > containers.MAXITEMSLOTS then
            return 
        end
        print("AddComponent")
        container.inst:AddComponent("pageable")
        print(container.opener)
        --reopen--
        if container.opener then
            local opener = container.opener
            container.inst:DoTaskInTime(.2, function(inst, container)
                print("closecontainer")
                container:Close()
            end, container)
            container.inst:DoTaskInTime(.3, function(inst, container, opener)
                print("opencontainer")
                container:Open(opener)
            end, container, opener)   
        end
        -----
    end
    if container.inst.components.pageable.pagecount >= inst.multi then return end
    if (container.inst.components.pageable.slotstrue or 1) * inst.multi > containers.MAXITEMSLOTS then
        return 
    end
    print("InitRefreshContainer")
    container.inst.components.pageable:RefreshContainer(inst.multi)
    container:RemoveItem(inst):Remove()
end




local function fn_2()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("pct_transformer_2")
    inst.AnimState:SetBuild("pct_transformer_2")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")
    inst.multi = 2
    inst.entity:SetPristine()

    if not _G.TheWorld.ismastersim then
        return inst
    end
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem:SetOnPutInInventoryFn(onputininv)
    inst.components.inventoryitem:SetOnDroppedFn(function(inst)
        inst:Remove()
    end)
    inst.components.inventoryitem.imagename = "pct_transformer"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/pct_transformer.xml"
    inst:AddTag("icebox_valid")
    MakeHauntableLaunch(inst)
    return inst
end
local function fn_3()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("pct_transformer_3")
    inst.AnimState:SetBuild("pct_transformer_3")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")
    inst.multi = 3
    inst.entity:SetPristine()

    if not _G.TheWorld.ismastersim then
        return inst
    end
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem:SetOnPutInInventoryFn(onputininv)
    inst.components.inventoryitem:SetOnDroppedFn(function(inst)
        inst:Remove()
    end)
    inst.components.inventoryitem.imagename = "pct_transformer"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/pct_transformer.xml"
    inst:AddTag("icebox_valid")
    MakeHauntableLaunch(inst)
    return inst
end
local function fn_5()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("pct_transformer_5")
    inst.AnimState:SetBuild("pct_transformer_5")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")
    inst.multi = 5
    inst.entity:SetPristine()

    if not _G.TheWorld.ismastersim then
        return inst
    end
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem:SetOnPutInInventoryFn(onputininv)
    inst.components.inventoryitem:SetOnDroppedFn(function(inst)
        inst:Remove()
    end)
    inst.components.inventoryitem.imagename = "pct_transformer"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/pct_transformer.xml"
    inst:AddTag("icebox_valid")
    MakeHauntableLaunch(inst)
    return inst
end
local function fn_10()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("pct_transformer_10")
    inst.AnimState:SetBuild("pct_transformer_10")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("sharp")
    inst.multi = 10
    inst.entity:SetPristine()

    if not _G.TheWorld.ismastersim then
        return inst
    end
    inst:AddComponent("inspectable")
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem:SetOnPutInInventoryFn(onputininv)
    inst.components.inventoryitem:SetOnDroppedFn(function(inst)
        inst:Remove()
    end)
    inst.components.inventoryitem.imagename = "pct_transformer"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/pct_transformer.xml"
    inst:AddTag("icebox_valid")
    MakeHauntableLaunch(inst)
    return inst
end














if PCT.LANGA == "chs" then
    STRINGS.NAMES.PCT_TRANSFORMER_2 = "次元转换器(2)"
    STRINGS.RECIPE_DESC.PCT_TRANSFORMER_2 = "放进容器使之变成次元容器"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.PCT_TRANSFORMER_2 = "放进容器使之变成次元容器\n"
    STRINGS.NAMES.PCT_TRANSFORMER_3 = "次元转换器(3)"
    STRINGS.RECIPE_DESC.PCT_TRANSFORMER_3 = "放进容器使之变成次元容器"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.PCT_TRANSFORMER_3 = "放进容器使之变成次元容器\n"
    STRINGS.NAMES.PCT_TRANSFORMER_5 = "次元转换器(5)"
    STRINGS.RECIPE_DESC.PCT_TRANSFORMER_5 = "放进容器使之变成次元容器"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.PCT_TRANSFORMER_5 = "放进容器使之变成次元容器\n"
    STRINGS.NAMES.PCT_TRANSFORMER_10 = "次元转换器(10)"
    STRINGS.RECIPE_DESC.PCT_TRANSFORMER_10 = "放进容器使之变成次元容器"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.PCT_TRANSFORMER_10 = "放进容器使之变成次元容器\n"
elseif PCT.LANGA == "eng" then
    STRINGS.NAMES.PCT_TRANSFORMER_2 = "Dimension transformer(2)"
    STRINGS.RECIPE_DESC.PCT_TRANSFORMER_2 = "Put it in any container and transform the container to a pageable container"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.PCT_TRANSFORMER_2 = "Put it in any container and transform the container to a pageable container\n"
    STRINGS.NAMES.PCT_TRANSFORMER_3 = "Dimension transformer(3)"
    STRINGS.RECIPE_DESC.PCT_TRANSFORMER_3 = "Put it in any container and transform the container to a pageable container"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.PCT_TRANSFORMER_3 = "Put it in any container and transform the container to a pageable container\n"
    STRINGS.NAMES.PCT_TRANSFORMER_5 = "Dimension transformer(5)"
    STRINGS.RECIPE_DESC.PCT_TRANSFORMER_5 = "Put it in any container and transform the container to a pageable container"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.PCT_TRANSFORMER_5 = "Put it in any container and transform the container to a pageable container\n"
    STRINGS.NAMES.PCT_TRANSFORMER_10 = "Dimension transformer(10)"
    STRINGS.RECIPE_DESC.PCT_TRANSFORMER_10 = "Put it in any container and transform the container to a pageable container"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.PCT_TRANSFORMER_10 = "Put it in any container and transform the container to a pageable container\n"
elseif PCT.LANGA == "cht" then
    STRINGS.NAMES.PCT_TRANSFORMER_2 = "次元轉換容器(2)"
    STRINGS.RECIPE_DESC.PCT_TRANSFORMER_2 = "放進容器使之變成次元容器"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.PCT_TRANSFORMER_2 = "放進容器使之變成次元容器\n" 
    STRINGS.NAMES.PCT_TRANSFORMER_3 = "次元轉換容器(3)"
    STRINGS.RECIPE_DESC.PCT_TRANSFORMER_3 = "放進容器使之變成次元容器"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.PCT_TRANSFORMER_3 = "放進容器使之變成次元容器\n"
    STRINGS.NAMES.PCT_TRANSFORMER_5 = "次元轉換容器(5)"
    STRINGS.RECIPE_DESC.PCT_TRANSFORMER_5 = "放進容器使之變成次元容器"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.PCT_TRANSFORMER_5 = "放進容器使之變成次元容器\n"
    STRINGS.NAMES.PCT_TRANSFORMER_10 = "次元轉換容器(10)"
    STRINGS.RECIPE_DESC.PCT_TRANSFORMER_10 = "放進容器使之變成次元容器"
    STRINGS.CHARACTERS.GENERIC.DESCRIBE.PCT_TRANSFORMER_10 = "放進容器使之變成次元容器\n"
end




return Prefab("pct_transformer_2", fn_2, assets),
    Prefab("pct_transformer_3", fn_3, assets),
    Prefab("pct_transformer_5", fn_5, assets),
    Prefab("pct_transformer_10", fn_10, assets)