local Widget = require("widgets/widget")
local Text = require("widgets/text")
local ImageButton = require("widgets/imagebutton")

local function OnLeftControl(self, control, down)
    if not down then
        return false
    end
    if control == CONTROL_ACCEPT then
        self:GetParent():OnPagePrev()
    end
    if control == CONTROL_SECONDARY then
        self:GetParent():OnPageNext()
    end
    return true
end
local function OnRightControl(self, control, down)
    if not down then
        return false
    end
    if control == CONTROL_ACCEPT then
        self:GetParent():OnPageNext()
    end
    if control == CONTROL_SECONDARY then
        self:GetParent():OnPagePrev()
    end
    return true
end

local PageWidget = Class(Widget, function ( self, containerinst)
    Widget._ctor(self, "PageWidget")
    self.containerinst = containerinst
    containerinst.components.pageable.pagewidget = self
    self:SetPosition(0, 0, 0)
    --self.text = self:AddChild(Text(BODYTEXTFONT, 50, "＋"))
    --self.text:SetPosition(0,0,0)
    self.button_page_left = self:AddChild(ImageButton("images/hud.xml", "turnarrow_icon.tex"))
    self.button_page_right = self:AddChild(ImageButton("images/hud.xml", "turnarrow_icon.tex"))
    self.button_page_left:SetPosition(-76/2 + 1 -10, -75, 0)
    self.button_page_right:SetPosition(76/2 + 1 +10, -75, 0)
    self.button_page_left:SetScale(-1, 1, 1)
    self.button_page_right:SetScale(1, 1, 1)
    self.button_page_left.OnControl = OnLeftControl
    self.button_page_right.OnControl = OnRightControl

    self:SetToBottomPos(containerinst.replica.container.widget.slotpos)

    --if self.containerinst.replica.container and 
    --    self.containerinst.replica.container.issidewidget then
    --        self.containerinst.replica.container:Oppener()
    --end
end)




function PageWidget:OnPagePrev()
    local cmp = self.containerinst.components.pageable
    if cmp then
        cmp:Page(1, true)
    end
end
function PageWidget:OnPageNext()
    local cmp = self.containerinst.components.pageable
    if cmp then
        cmp:Page(1)
    end
end


function PageWidget:SetToBottomPos(slotpos)
    if not slotpos then return end
    local x1,x2,y = 3000,-3000,3000
    for k,v in pairs(slotpos) do
        if v.x < x1 then
            x1 = v.x
        end
        if v.x > x2 then
            x2 = v.x
        end
        if v.y < y then
            y = v.y
        end
    end
    self:SetPosition(math.floor((x1+x2)/2), y, 0)
end


return PageWidget