#include <stdio.h>
#include <stdarg.h>
//#include <stdint.h>

/*
typedef struct AVRational{
	int num; ///< numerator
	int den; ///< denominator
} AVRational;

__declspec(dllexport) int my_av_cmp_q(AVRational a, AVRational b)
{
	const int64_t tmp= a.num * (int64_t)b.den - b.num * (int64_t)a.den;
	if(tmp) return (tmp>>63)|1;
	else    return 0;
}
*/

__declspec(dllexport) int my_vsprintf(char *buf, const char* fmt, va_list vl)
{
	return vsprintf(buf, fmt, vl);
}

__declspec(dllexport) int my_fprintf (FILE *fp, const char *fmt, ...)
{
	int ret;
	va_list vl;
	va_start(vl, fmt);
	ret = vfprintf(fp, fmt, vl);
	va_end(vl);
	return ret;
}

__declspec(dllexport) int my_snprintf(char *buf, size_t size, const char *fmt, ...)
{
	int ret;
	va_list vl;
	va_start(vl, fmt);
	ret = vsnprintf(buf, size, fmt, vl);
	va_end(vl);
	return ret;
}

__declspec(dllexport) FILE *my_fopen(const char *path, const char *mode)
{
	return fopen(path, mode);
}

__declspec(dllexport) long my_ftell(FILE *fp)
{
	return ftell(fp);
}

__declspec(dllexport) size_t my_fread(void *ptr, size_t size, size_t nitems, FILE *fp)
{
	return fread(ptr, size, nitems, fp);
}

__declspec(dllexport) size_t my_fwrite(const void *ptr, size_t size, size_t nitems, FILE *fp)
{
	return fwrite(ptr, size, nitems, fp);
}

__declspec(dllexport) int my_fseek(FILE *fp, long offset, int whence)
{
	return fseek(fp, offset, whence);
}

__declspec(dllexport) int my_fclose(FILE *fp)
{
	return fclose(fp);
}

__declspec(dllexport) char *my_strtok(char *s, char *delim)
{
	return (char *)strtok(s, delim);
}

__declspec(dllexport) long my_strtol(const char *s, char **endptr, int radix)
{
	return strtol(s, endptr, radix);
}
__declspec(dllexport) double my_strtod(const char *s, char **endptr)
{
	return strtod(s, endptr);
}
